% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_schema.R
\name{get_schema}
\alias{get_schema}
\title{Get the Table Schema of a Data Resource}
\usage{
get_schema(package, resource_name)
}
\arguments{
\item{package}{Data Package object, as returned by \code{\link[=read_package]{read_package()}} or
\code{\link[=create_package]{create_package()}}.}

\item{resource_name}{Name of the Data Resource.}
}
\value{
List describing a Table Schema.
}
\description{
Returns the Table Schema of a Data Resource (in a Data Package), i.e. the
content of its \code{schema} property, describing the resource's fields, data
types, relationships, and missing values.
The resource must be a \href{https://specs.frictionlessdata.io/tabular-data-resource/}{Tabular Data Resource}.
}
\details{
See \code{vignette("table-schema")} to learn more about Table Schema.
}
\examples{
# Load the example Data Package
package <- example_package()

# Get the Table Schema for the resource "observations"
schema <- get_schema(package, "observations")
str(schema)
}
\concept{accessor functions}
