% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_valid_primary_key.R
\name{is_valid_primary_key}
\alias{is_valid_primary_key}
\title{Is a Key a Valid Potential Primary Key for a \code{data.frame}?}
\usage{
is_valid_primary_key(data, key, verbose = TRUE)
}
\arguments{
\item{data}{The \code{data.frame} for which you want to find valid potential
primary key.}

\item{key}{Character vector containing a subset of the columns names of
\code{data}.}

\item{verbose}{Be verbose?}
}
\value{
\code{\link{TRUE}}, if \code{key} is a valid primary key,
\code{\link{FALSE}} otherwise.
}
\description{
I sometimes see tables with obscure structure so I try to guess their primary
keys.
}
\examples{
is_valid_primary_key(mtcars, "qsec")
is_valid_primary_key(mtcars, "carb")
is_valid_primary_key(mtcars, c("qsec", "gear"))
is_valid_primary_key(mtcars, c("qsec", "carb"))
cars <- mtcars
cars$id <-  seq_len(nrow(cars))
is_valid_primary_key(cars, "id")
}
\seealso{
Other bits and pieces: 
\code{\link{char2factor}()},
\code{\link{golden_ratio}()},
\code{\link{is_difftime_less}()},
\code{\link{pause}()},
\code{\link{r_cmd_install}()},
\code{\link{rownames2col}()},
\code{\link{str2num}()},
\code{\link{string2words}()},
\code{\link{strip_off_attributes}()},
\code{\link{tapply}()},
\code{\link{throw}()}
}
\concept{bits and pieces}
