% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{fsSimilarity}
\alias{fsSimilarity}
\title{Calculating similarity of two feature sets}
\usage{
fsSimilarity(
  feature.set1,
  feature.set2,
  cutoff = FALSE,
  threshold = 1,
  method = c("Kuncheva", "intersection")
)
}
\arguments{
\item{feature.set1}{a matrix that contains feature weights.}

\item{feature.set2}{a matrix that contains feature weights.}

\item{cutoff}{logical. If true, ihe input features sets are cut-off using the \code{cutoff} function with a specified \code{threshold}.
By default is FALSE.}

\item{threshold}{the threshold for feature selection using the \code{cutoff} function. By default is 1 (no cut-off)}

\item{method}{a similarity metric.
Implemented metrics:
\itemize{
 \item{\strong{"intersection"}}{ - a share of matching features to maximal possible number of matching features}
 \item{\strong{"Kuncheva"}}{ - Kuncheva-like correction to the expected number of features matched by chance. See Kuncheva (2007)
 }
}}
}
\value{
returns a value from the [0,1] interval, where 1 is for absolutely identical feature sets.
}
\description{
\code{fsSimilarity} implements different methods for calculation similarity of two feature sets.
}
\examples{

# Load traffic data
data(traffic.mini)

# Scaling is sometimes useful for feature selection
# Exclude the first column - it contains timestamps
data <- scale(traffic.mini$data[,-1])

mCCF<-fsMTS(data, max.lag=3, method="CCF")
mLARS<-fsMTS(data, max.lag=3, method="LARS")
fsSimilarity(mCCF, mLARS, cutoff=TRUE, threshold=0.2, method="Kuncheva")
fsSimilarity(mCCF, mLARS, cutoff=TRUE, threshold=0.2, method="intersection")

}
\references{
Kuncheva L., 2007, A stability index for feature selection. In: 25th IASTED international multi-conference: artificial intelligence and applications, pp. 390–395
}
