% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis_meshes.R
\name{vis.coloredmeshes.rotating}
\alias{vis.coloredmeshes.rotating}
\title{Visualize a list of colored meshes in a single scene and rotate them, movie-style.}
\usage{
vis.coloredmeshes.rotating(
  coloredmeshes,
  background = "white",
  skip_all_na = TRUE,
  style = "default",
  x = 0,
  y = 0,
  z = 1,
  rpm = 6,
  duration = 10,
  rgloptions = list(),
  rglactions = list()
)
}
\arguments{
\item{coloredmeshes}{list of coloredmesh. A coloredmesh is a named list as returned by the coloredmesh.from.* functions. It has the entries 'mesh' of type tmesh3d, a 'col', which is a color specification for such a mesh.}

\item{background}{string, background color passed to rgl::bg3d()}

\item{skip_all_na}{logical, whether to skip (i.e., not render) meshes in the list that have the property 'rendner' set to FALSE. Defaults to TRUE. Practically, this means that a hemisphere for which the data was not given is not rendered, instead of being rendered in a single color.}

\item{style}{a named list of style parameters or a string specifying an available style by name (e.g., 'shiny'). Defaults to 'default', the default style.}

\item{x}{rotation x axis value, passed to \code{\link{spin3d}}. Defaults to 0.}

\item{y}{rotation y axis value, passed to \code{\link{spin3d}}. Defaults to 1.}

\item{z}{rotation z axis value, passed to \code{\link{spin3d}}. Defaults to 0.}

\item{rpm}{rotation rpm value, passed to \code{\link{spin3d}}. Defaults to 15.}

\item{duration}{rotation duration value, passed to \code{\link{spin3d}}. Defaults to 20.}

\item{rgloptions}{option list passed to \code{\link{par3d}}. Example: rgloptions = list("windowRect"=c(50,50,1000,1000));}

\item{rglactions}{named list. A list in which the names are from a set of pre-defined actions. Defaults to the empty list.}
}
\value{
the list of visualized coloredmeshes
}
\description{
Visualize a list of colored meshes in a single scene and rotate them, movie-style.
}
\keyword{internal}
