% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fsdir_abstraction_group.R
\name{write.group.morph.standard.singlehemi}
\alias{write.group.morph.standard.singlehemi}
\title{Write single hemi per-vertex data for a group of subjects to given file names.}
\usage{
write.group.morph.standard.singlehemi(
  filepaths,
  data,
  format = "auto",
  create_dirs = TRUE
)
}
\arguments{
\item{filepaths}{vector of character strings, the full paths to the output files, including file names and extension.}

\item{data}{numerical matrix or data.frame, the morph data for a single hemi (as returned by \code{group.morph.standard}). Number of subjects (columns) must match the length of the 'filepaths'.}

\item{format}{character string, a valid format spec for \code{freesurferformats::write.fs.morph}, e.g., "auto" to derive from filename, "mgh", "mgz", "curv" or others.}

\item{create_dirs}{logical, whether to create missing (sub) directories which occur in the 'filepaths'.}
}
\description{
Write single hemi per-vertex data for a group of subjects to given file names.
}
\keyword{internal}
