% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fcts.R
\name{load_text_content}
\alias{load_text_content}
\title{Load the content of a text file.}
\usage{
load_text_content(path, min.confidence = 0)
}
\arguments{
\item{path}{Path to the file from which to load content.}

\item{min.confidence}{The minimum confidence value (between 0 and 1)}
}
\value{
The content of the file as a single character value,
\code{NA_character_} if encoding was not recognized.
}
\description{
Load the content of a text file, trying to guess file encoding.
The content is returned as a single character value.
}
\examples{
# Create a file in Latin-1 encoding
text_file <- tempfile('myfile', fileext = '.txt')
dir.create(dirname(text_file), recursive = TRUE)
x <- iconv("Qui sème le vent récolte la tempête.",
           from = "utf8", to = "latin1")
stringi::stri_write_lines(x, text_file, encoding = "latin1")

# Load its content
content <- fscache::load_text_content(text_file)
content

# Remove file
unlink(text_file)

}
