% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fsl_dilate.R, R/fsldilate.R
\name{fsl_dilate}
\alias{fsl_dilate}
\alias{fsldilate}
\title{Dilate image using FSL}
\usage{
fsl_dilate(..., outfile = tempfile(fileext = ".nii.gz"), retimg = FALSE)

fsldilate(file, outfile = NULL, retimg = TRUE, reorient = FALSE,
  intern = FALSE, kopts = "", opts = "", verbose = TRUE, ...)
}
\arguments{
\item{...}{additional arguments passed to \code{\link{readnii}}.}

\item{outfile}{(character) resultant dilated image name}

\item{retimg}{(logical) return image of class nifti}

\item{file}{(character) image to be dilated}

\item{reorient}{(logical) If retimg, should file be reoriented when read in?
Passed to \code{\link{readnii}}.}

\item{intern}{(logical) to be passed to \code{\link{system}}}

\item{kopts}{(character) options for kernel}

\item{opts}{(character) additional options to be passed to fslmaths}

\item{verbose}{(logical) print out command before running}
}
\value{
Result from system command, depends if intern is TRUE or FALSE.  If 
retimg is TRUE, then the image will be returned.
}
\description{
This function calls \code{fslmaths -ero} after inverting the image
to dilate an image with either 
the default FSL kernel or the kernel specified in \code{kopts}.  The function
either saves the image or returns an object of class nifti.
}
\note{
Functions with underscores have different defaults
and will return an output filename, so to be used for piping
}
\examples{
if (have.fsl()){
system.time({
dims = c(50, 50, 20)
x = array(rnorm(prod(dims)), dim = dims) 
img = nifti(x, dim= dims, 
datatype = convert.datatype()$FLOAT32, cal.min = min(x), 
cal.max = max(x), pixdim = rep(1, 4))
mask = img > .5
dilated = fsldilate(mask, kopts = "-kernel boxv 5", retimg=TRUE)
})
}    
}
