% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CkSNUCpair.R
\name{CkSNUCpair}
\alias{CkSNUCpair}
\title{Composition of k-Spaced Nucleotides Pairs}
\usage{
CkSNUCpair(
  seqs,
  rng = 3,
  upto = FALSE,
  ORF = FALSE,
  reverseORF = TRUE,
  normalized = TRUE,
  label = c()
)
}
\arguments{
\item{seqs}{is a FASTA file containing nucleotide sequences. The sequences start
with '>'. Also, seqs could be a string vector. Each element of the vector is a nucleotide sequence.}

\item{rng}{This parameter can be a number or a vector. Each element of the vector shows the number of spaces between nucleotide pairs.
For each k in the rng vector, a new vector (whose size is 16) is created which contains the frequency of pairs with k gaps.}

\item{upto}{It is a logical parameter. The default value is FALSE. If rng is a number and upto is set to TRUE, rng is converted
to a vector with values from [0 to rng].}

\item{ORF}{(Open Reading Frame) is a logical parameter. If it is set to true, ORF region of each sequence is considered instead of the original sequence (i.e., 3-frame).}

\item{reverseORF}{is a logical parameter. It is enabled only if ORF is true.
If reverseORF is true, ORF region will be searched in the sequence and also in the reverse complement of the sequence (i.e., 6-frame).}

\item{normalized}{is a logical parameter. When it is FALSE, the return value of the function does not change. Otherwise, the return value is normalized using the length of the sequence.}

\item{label}{is an optional parameter. It is a vector whose length is equivalent to the number of sequences. It shows the class of
each entry (i.e., sequence).}
}
\value{
The function returns a feature matrix. The number of rows is equal to the number of sequences and
the number of columns is 16*(length of rng vector).
}
\description{
This function calculates the composition of k-spaced nucleotide pairs. In other words, it
computes the frequency of all nucleotide pairs witn k spaces.
}
\note{
'upto' is enabled only when rng is a number and not a vector.
}
\examples{


fileLNC<-system.file("extdata/Athaliana_LNCRNA.fa",package="ftrCOOL")
mat1<-CkSNUCpair(seqs=fileLNC,rng=2,upto=TRUE,ORF=TRUE,reverseORF=FALSE)
mat2<-CkSNUCpair(seqs=fileLNC,rng=c(1,3,5))

}
