% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/names.R
\name{names}
\alias{names}
\alias{set_names}
\alias{remove_names}
\alias{\%names\%}
\alias{is_named}
\title{Set names}
\usage{
set_names(x, nm = x)

remove_names(x)

x \%names\% nm

is_named(x, zero_ok = TRUE)
}
\arguments{
\item{x}{A vector of values}

\item{nm}{A vector of names}

\item{zero_ok}{If \code{TRUE} allows use of \code{""} as a \emph{special} name}
}
\value{
\code{x} with \code{nm} values assigned to names (if \code{x} is \code{NULL}, \code{NULL} is
returned)
}
\description{
Sets or removes names
}
\examples{
set_names(1:5)
set_names(1:5, c("a", "b", "c", "d", "e"))

x <- c(a = 1, b = 2)
remove_names(x)
x \%names\% c("c", "d")
is_named(x)

}
