% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/cache.R
\name{cache}
\alias{cache}
\alias{cache_clear}
\alias{cache_options_get}
\alias{cache_options_set}
\title{Cache blobs of json, xml or pdfs of text from ft_get() function}
\usage{
cache_options_set(cache = TRUE, backend = "rds", path = "~/.fulltext")

cache_options_get()

cache_clear(cachetype = NULL)
}
\arguments{
\item{cache}{(logical) If TRUE, cache results, if not objects saved within R session.}

\item{backend}{(character) One of rds, rcache, redis}

\item{path}{path to local storage. used only if \code{backend="rds"}}

\item{cachetype}{The cache type}
}
\description{
Cache blobs of json, xml or pdfs of text from ft_get() function
}
\examples{
\dontrun{
ft_get('10.1371/journal.pone.0086169', from='plos', cache=FALSE)
ft_get('10.1371/journal.pone.0086169', from='plos', cache=TRUE)

cache_options_set(backend="redis")
cache_options_get()
(x <- ft_get('10.1371/journal.pone.0086169', from='plos', cache=TRUE, backend="redis"))
x \%>\% collect()

cache_options_set(backend="rcache")
cache_options_get()
(x <- ft_get('10.1371/journal.pone.0086169', from='plos'))
x \%>\% collect()

# Many different sources
(res <- ft_search(query='ecology', from='entrez'))
cache_options_set(backend="rds")
out <- ft_get(res)
out$entrez
out \%>\% collect() \%>\% chunks("title")
}
}

