% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05_fault_detection.R
\name{which_ooc}
\alias{which_ooc}
\title{Get the index of the out of control observations from control charts}
\usage{
which_ooc(cclist)
}
\arguments{
\item{cclist}{A \code{data.frame} produced by
\code{\link{control_charts_sof_pc}}.}
}
\value{
A list of as many \code{data.frame} objects as
the control charts in \code{cclist}.
Each data frame has two columns, the \code{n} contains
an index number giving the observation in the
phase II data set, i.e. 1 for the first observation,
2 for the second, and so on,
while the \code{id} column contains the id of the observation,
which can be general and
depends on the specific data set.
}
\description{
This function returns a list for each control chart and returns
the id of all observations that are out of control in that control chart.
}
\examples{
library(funcharts)
data("air")
air <- lapply(air, function(x) x[201:300, , drop = FALSE])
fun_covariates <- c("CO", "temperature")
mfdobj_x <- get_mfd_list(air[fun_covariates],
                         n_basis = 15,
                         lambda = 1e-2)
y <- rowMeans(air$NO2)
y1 <- y[1:60]
y2 <- y[91:100]
mfdobj_x1 <- mfdobj_x[1:60]
mfdobj_x_tuning <- mfdobj_x[61:90]
mfdobj_x2 <- mfdobj_x[91:100]
mod <- sof_pc(y1, mfdobj_x1)
cclist <- control_charts_sof_pc(mod = mod,
                                y_test = y2,
                                mfdobj_x_test = mfdobj_x2,
                                mfdobj_x_tuning = mfdobj_x_tuning)
which_ooc(cclist)

}
