% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00_mfd.R
\name{get_mfd_array}
\alias{get_mfd_array}
\title{Get Multivariate Functional Data from a three-dimensional array}
\usage{
get_mfd_array(
  data_array,
  grid = NULL,
  n_basis = 30,
  n_order = 4,
  basisobj = NULL,
  Lfdobj = 2,
  lambda = NULL,
  lambda_grid = 10^seq(-10, 1, length.out = 10),
  ncores = 1
)
}
\arguments{
\item{data_array}{A three-dimensional array.
The first dimension corresponds to argument values,
the second to replications,
and the third to variables within replications.}

\item{grid}{See \code{\link{get_mfd_list}}.}

\item{n_basis}{See \code{\link{get_mfd_list}}.}

\item{n_order}{#' See \code{\link{get_mfd_list}}.}

\item{basisobj}{#' See \code{\link{get_mfd_list}}.}

\item{Lfdobj}{#' See \code{\link{get_mfd_list}}.}

\item{lambda}{See \code{\link{get_mfd_list}}.}

\item{lambda_grid}{See \code{\link{get_mfd_list}}.}

\item{ncores}{Deprecated. See \code{\link{get_mfd_list}}.}
}
\value{
An object of class \code{mfd}.
See also \code{?mfd} for additional details on the
multivariate functional data class.
}
\description{
Get Multivariate Functional Data from a three-dimensional array
}
\examples{
library(funcharts)
library(fda)
data("CanadianWeather")
mfdobj <- get_mfd_array(CanadianWeather$dailyAv[, 1:10, ],
                        lambda = 1e-5)
plot_mfd(mfdobj)

}
\seealso{
\code{\link{get_mfd_list}}, \code{\link{get_mfd_df}}
}
