% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmfcc.R
\name{RoMFCC_PhaseII}
\alias{RoMFCC_PhaseII}
\title{Robust Multivariate Functional Control Charts - Phase II}
\usage{
RoMFCC_PhaseII(mfdobj_new, mod_phase1)
}
\arguments{
\item{mfdobj_new}{A multivariate functional data object of class mfd, containing the
Phase II observations to be monitored.}

\item{mod_phase1}{Output obtained by applying the function \code{RoMFCC_PhaseI}
to perform Phase I. See \code{\link{RoMFCC_PhaseI}}.}
}
\value{
A \code{data.frame} with as many rows as the number of
multivariate functional observations in the phase II data set and
the following columns:
\itemize{
\item one \code{id} column identifying the multivariate functional observation
in the phase II data set,
\item one \code{T2} column containing the Hotelling T2 statistic
calculated for all observations,
\item one column per each functional variable,
containing its contribution to the T2 statistic,
\item one \code{spe} column containing the SPE statistic calculated
for all observations,
\item \code{T2_lim} gives the upper control limit of
the Hotelling's T2 control chart,
\item \code{spe_lim} gives the upper control limit of the SPE control chart
}
}
\description{
It calculates the Hotelling's and SPE monitoring statistics
needed to plot the Robust Multivariate Functional Control Chart in Phase II.
}
\examples{
\dontrun{
library(funcharts)
mfdobj <- get_mfd_list(air, n_basis = 5)
nobs <- dim(mfdobj$coefs)[2]
set.seed(0)
ids <- sample(1:nobs)
mfdobj1 <- mfdobj[ids[1:100]]
mfdobj_tuning <- mfdobj[ids[101:300]]
mfdobj2 <- mfdobj[ids[-(1:300)]]
mod_phase1 <- RoMFCC_PhaseI(mfdobj = mfdobj1,
                            mfdobj_tuning = mfdobj_tuning)
phase2 <- RoMFCC_PhaseII(mfdobj_new = mfdobj2,
                         mod_phase1 = mod_phase1)
plot_control_charts(phase2)
}

}
\references{
Capezza, C., Centofanti, F., Lepore, A., Palumbo, B. (2024)
Robust Multivariate Functional Control Charts.
\emph{Technometrics}, 66(4):531--547, \url{doi:10.1080/00401706.2024.2327346}.
}
\author{
C. Capezza, F. Centofanti
}
