% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/skew.R
\name{skew}
\alias{skew}
\title{Calculate Univariate Skewness for a Vector or Matrix}
\usage{
skew(x)
}
\arguments{
\item{x}{Either a vector or matrix of numeric values.}
}
\value{
\item{Skewness for each column in x.}{}
}
\description{
Calculate univariate skewness for vector or matrix (algorithm G1 in Joanes &
Gill, 1998).
}
\examples{

x <- matrix(rnorm(1000), 100, 10)
skew(x)

}
\references{
Joanes, D. N. & Gill, C. A. (1998). Comparing measures of sample
skewness and kurtosis. \emph{The Statistician, 47}, 183-189.
}
\seealso{
\code{\link{kurt}}
}
\author{
Niels Waller
}
\keyword{Statistics}
