% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funky_heatmap.R
\name{funky_heatmap}
\alias{funky_heatmap}
\title{Generate a funky heatmaps for benchmarks}
\usage{
funky_heatmap(
  data,
  column_info = NULL,
  row_info = NULL,
  column_groups = NULL,
  row_groups = NULL,
  palettes = NULL,
  legends = NULL,
  position_args = position_arguments(),
  scale_column = TRUE,
  add_abc = TRUE,
  col_annot_offset,
  col_annot_angle,
  expand
)
}
\arguments{
\item{data}{A data frame with items by row and features in the columns.
Must contain one column named \code{"id"}.}

\item{column_info}{A data frame describing which columns in \code{data} to
plot. This data frame should contain the following columns:
\itemize{
\item \code{id} (\code{character}, required): A column name in \code{data} to plot. Determines the
size of the resulting geoms, and also the color unless \code{color} is
specified.
\item \code{id_color} (\code{character}): A column name in \code{data} to use for the color
of the resulting geoms. If \code{NA}, the \code{id} column will be used.
\item \code{id_size} (\code{character}): A column name in \code{data} to use for the size
of the resulting geoms. If \code{NA}, the \code{id} column will be used.
\item \code{name} (\code{character}): A label for the column. If \code{NA} or \code{""},
no label will be plotted. If this column is missing, \code{id} will
be used to generate the \code{name} column.
\item \code{geom} (\code{character}): The geom of the column. Must be one of:
\code{"funkyrect"}, \code{"circle"}, \code{"rect"}, \code{"bar"}, \code{"pie"}, \code{"text"} or \code{"image"}.
For \code{"text"}, the corresponding column in \code{data} must be a \code{character}.
For \code{"pie"}, the column must be a list of named numeric vectors.
For all other geoms, the column must be a \code{numeric}.
\item \code{group} (\code{character}): The grouping id of each column, must match with
\code{column_groups$group}. If this column is missing or all values are \code{NA},
columns are assumed not to be grouped.
\item \code{palette} (\code{character}): Which palette to colour the geom by.
Each value should have a matching value in \code{palettes$palette}.
\item \code{width}: Custom width for this column (default: 1).
\item \code{overlay}: Whether to overlay this column over the previous column.
If so, the width of that column will be inherited.
\item \code{legend}: Whether or not to add a legend for this column.
\item \code{hjust}: Horizontal alignment of the bar, must be between [0,1]
(only for \code{geom = "bar"}).
\item \code{vjust}: Vertical alignment of the label, must be between [0,1]
(only for \code{geom = "text"}).
\item \code{size}: Size of the label, must be a numeric value
(only for \code{geom = "text"}).
\item \code{label}: Which column to use as a label (only for \code{geom = "text"}).
\item \code{directory}: Which directory to use to find the images (only for \code{geom = "image"}).
\item \code{extension}: The extension of the images (only for \code{geom = "image"}).
\item \code{draw_outline}: Whether or not to draw bounding guides (only for \code{geom == "bar"}).
Default: \code{TRUE}.
\item \code{options} (\code{list} or \code{json}): Any of the options above. Any values in this
column will be spread across the other columns. This is useful for
not having to provide a data frame with 1000s of columns.
This column can be a json string.
}}

\item{row_info}{A data frame describing the rows of \code{data}.
This data should contain two columns:
\itemize{
\item \code{id} (\code{character}): Corresponds to the column \code{data$id}.
\item \code{group} (\code{character}): The group of the row.
If all are \code{NA}, the rows will not be split up into groups.
}}

\item{column_groups}{A data frame describing of how to group the columns
in \code{column_info}. Can consist of the following columns:
\itemize{
\item \code{group} (\code{character}): The corresponding group in \code{column_info$group}.
\item \code{palette} (\code{character}, optional): The palette used to colour the
column group backgrounds.
\item \code{level1} (\code{character}): The label at the highest level.
\item \code{level2} (\code{character}, optional): The label at the middle level.
\item \code{level3} (\code{character}, optional): The label at the lowest level
(not recommended).
}}

\item{row_groups}{A data frame describing of how to group the rows
in \code{row_info}. Can consist of the following columns:
\itemize{
\item \code{group} (\code{character}): The corresponding group in \code{row_info$group}.
\item \code{level1} (\code{character}): The label at the highest level.
\item \code{level2} (\code{character}, optional): The label at the middle level.
\item \code{level3} (\code{character}, optional): The label at the lowest level
(not recommended).
}}

\item{palettes}{A named list of palettes. Each entry in \code{column_info$palette}
should have an entry in this object. If an entry is missing, the type
of the column will be inferred (categorical or numerical) and one of the
default palettes will be applied. Alternatively, the name of one of the
standard palette names can be used:
\itemize{
\item \code{numerical}: \code{"Greys"}, \code{"Blues"}, \code{"Reds"}, \code{"YlOrBr"}, \code{"Greens"}
\item \code{categorical}: \code{"Set3"}, \code{"Set1"}, \code{"Set2"}, \code{"Dark2"}
}}

\item{legends}{A list of legends to add to the plot. Each entry in
\code{column_info$legend} should have a corresponding entry in this object.
Each entry should be a list with the following names:
\itemize{
\item \code{palette} (\code{character}): The palette to use for the legend. Must be
a value in \code{palettes}.
\item \code{geom} (\code{character}): The geom of the legend. Must be one of:
\code{"funkyrect"}, \code{"circle"}, \code{"rect"}, \code{"bar"}, \code{"pie"}, \code{"text"}, \code{"image"}.
\item \code{title} (\code{character}, optional): The title of the legend. Defaults
to the palette name.
\item \code{enabled} (\code{logical}, optional): Whether or not to add the legend.
Defaults to \code{TRUE}.
\item \code{labels} (\code{character}, optional): The labels to use for the legend.
The defaults depend on the selected geom.
\item \code{size} (\code{numeric}, optional): The size of the listed geoms.
The defaults depend on the selected geom.
\item \code{color} (\code{character}, optional): The color of the listed geoms.
The defaults depend on the selected geom.
\item \code{values} (optional): Used as values for the text and image geoms.
\item \code{label_width} (\code{numeric}, optional): The width of the labels
(only when geom is \code{text} or \code{pie}). Defaults to \code{1}
for text and \code{2} for images.
\item \code{value_width} (\code{numeric}, optional): The width of the values
(only for \code{geom = "text"}). Defaults to \code{2}.
\item \code{label_hjust} (\code{numeric}, optional): The horizontal alignment of the
labels (only when geom is \code{circle}, \code{rect} or \code{funkyrect}).
Defaults to \code{0.5}.
}}

\item{position_args}{Sets parameters that affect positioning within a
plot, such as row and column dimensions, annotation details, and the
expansion directions of the plot. See \code{position_arguments()} for more information.}

\item{scale_column}{Whether or not to apply min-max scaling to each
numerical column.}

\item{add_abc}{Whether or not to add subfigure labels to the different
columns groups.}

\item{col_annot_offset}{DEPRECATED: use \code{position_args = position_arguments(col_annot_offset = ...)} instead.}

\item{col_annot_angle}{DEPRECATED: use \code{position_args = position_arguments(col_annot_angle = ...)} instead.}

\item{expand}{DEPRECATED: use \verb{position_args = position_arguments(expand_* = ...)} instead.}
}
\value{
A ggplot. \code{.$width} and \code{.$height} are suggested dimensions for
storing the plot with \code{\link[=ggsave]{ggsave()}}.
}
\description{
Allows generating heatmap-like visualisations for benchmark data
frames. Funky heatmaps can be fine-tuned by providing annotations of the
columns and rows, which allows assigning multiple palettes or geometries
or grouping rows and columns together in categories.
}
\examples{
library(tibble, warn.conflicts = FALSE)

data("mtcars")

data <- rownames_to_column(mtcars, "id")

funky_heatmap(data)
}
