% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GombayCPA_test.R
\name{GombayCPA_test}
\alias{GombayCPA_test}
\title{Change Point Detection in Autoregressive Time Series}
\usage{
GombayCPA_test(
  y,
  a.order,
  alternatives = c("two-sided", "greater", "lesser", "temporary"),
  crit.type = c("asymptotic", "bootstrap"),
  num.bootstrap = 1000
)
}
\arguments{
\item{y}{a vector that contains univariate time-series observations. Missing values are not allowed.}

\item{a.order}{order of the autoregressive model which must be a non-negative integer number.}

\item{alternatives}{a string parameter that specifies a type of the test (i.e., "two-sided",
"greater", "lesser", and "temporary").  The option "temporary" examines the temporary change
in one of the parameters \insertCite{Gombay_2008}{funtimes}.}

\item{crit.type}{method of obtaining critical values: "asymptotic" (default) or "bootstrap".}

\item{num.bootstrap}{number of bootstrap replications if \code{crit.type = "bootstrap"}.
The default number is 1000.}
}
\value{
A list with the following components:
\item{index}{points of change for each parameter. The value of the \code{"alternatives"}
determines the return:
"temporary" -- returns max, min, and abs.max points;
"greater" -- returns max points;
"lesser" --  returns min points;
"two-sided" -- returns abs.max.}
\item{stats}{test statistic values for change points in mean, var, phi.}
\item{p.values}{\code{p-value} of the change point test.}
}
\description{
The function detects change points in autoregressive (AR) models for time series. Changes
can be detected in any of \code{p + 2} (mean, var, phi) autoregressive parameters where \code{p}
is the order of the AR model. The test statistic is based on the efficient score vector \insertCite{Gombay_2008}{funtimes}.
}
\details{
The function tests for a temporary change and a change in specific model parameters.
Critical values can be estimated via asymptotic distribution \code{"asymptotic"} (i.e., the
default option) or sieve bootstrap \code{"bootstrap"}. The function employs internal
function \code{change.point} and sieve bootstrap \code{change.point.sieve} function.
}
\examples{
\dontrun{
#Example 1:

#Simulate some time series:
series_1 = arima.sim(n = 100, list(order = c(2,0,0), ar = c(-0.7, -0.1)))
series_2 = arima.sim(n = 200, list(order = c(2,0,0), ar = c(0.1, -0.6)))
main_series = c(series_1, series_2)

result11 = GombayCPA_test(series_1, 2, "two-sided")
result11 #== No change point ===#

result12 = GombayCPA_test(main_series, 2, "two-sided")
result12  #=== One change at phi values ===#

result13 = GombayCPA_test(main_series, 2, "two-sided", "bootstrap")
result13  #=== One change at phi values ===#



#Example 2:

#From the package 'Ecdat' consider a time series with annual world number of victims of 
#terrorism in the US from 1970 till 2016:
c.data = Ecdat::terrorism['nkill.us']
nkill.us.ts <- ts(c.data, start = 1970, end = 2016)

#Now perform a change point detection with one sided tests:
GombayCPA_test(nkill.us.ts, 0, "lesser")
GombayCPA_test(nkill.us.ts, 0, "greater")
nkill.us.ts[32]
year = 1970 + 31
print(year)
plot(nkill.us.ts)

#In both cases we find that the change point is located at the position 31 or 32. We can 
# examine it further by checking the value of this position (using: nkill.us.ts[32]) as well as
# by plotting the graph (using: plot(nkill.us.ts)). The detected change point corresponds to 
#the year of 2001, when the 9/11 attack happened.
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{mcusum.test}}  change point test for regression and
\code{\link[Ecdat]{terrorism}} dataset used in the Example 2
}
\author{
Palina Niamkova, Dorcas Ofori-Boateng, Yulia R. Gel
}
\keyword{changepoint}
\keyword{ts}
