% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preparation.R
\name{acquireDirectoryStructure}
\alias{acquireDirectoryStructure}
\title{Acquire structure of input directory}
\usage{
acquireDirectoryStructure(dataFolder, coordinateFilenames, tasFilenames,
  timeFilenames, models_to_run, dataDirectories, threshold_ensemble,
  thresholdBoundaries)
}
\arguments{
\item{dataFolder}{Character string with pathway to a directory with
climate projection data. This directory must have a specific structure--
see the \code{futureheatwaves} vignette for guidance on setting up this
directory.}

\item{coordinateFilenames}{Character string the with filename of each
grid point location file. This filename should be identical for all
ensemble member subdirectories included in the \code{dataFolder} directory.
See the package vignette for an example of the required structure for this
file.}

\item{tasFilenames}{Character string the with filename of each climate
projection file. This filename should be identical for all ensemble
member subdirectories included in the \code{dataFolder} directory. See the
package vignette for an example of the required structure for this file.}

\item{timeFilenames}{Character string the with filename of each projection
dates file. This filename should be identical for all ensemble
member  subdirectories included in the \code{dataFolder} directory. See
the package vignette for an example of the required structure for this
file.}

\item{models_to_run}{A character vector with either "all" (the default),
in which case the function runs through all models in the \code{dataFolder}
directory, or the names of the models to run, using the names of each
model's subdirectory within the data directory (e.g.,
\code{c("bcc1", "ccsm")}).}

\item{dataDirectories}{A list object, with two elements, one for each of the
two subdirectories included in the main directory. Typically, these will
be separate directories of historical and projection experiments from
climate models. Each element of the list should be named with the name of
the subdirectory and should provide a numeric vector with the starting and
ending years of the data within each of the two subdirectories (e.g.,
\code{list("historical" = c(1990, 1999), "rcp85" = c(2060, 2079))}
for a \code{dataFolder} with historical experiment data for 1990 to 1999
and RCP8.5 projections for 2060 to 2079).}

\item{threshold_ensemble}{A character vector giving the name of the ensemble
member that should be used when determining the city-specific threshold
temperatures  for each climate model (e.g., \code{"r1i1p1"}). This
threshold is used for relative heat wave definitions. See the
\code{futureheatwaves} vignette for more on heat wave definitions.
If any climate model lacks that ensemble member for the specified
dates for calculating the threshold, it will be excluded from the
processing.}

\item{thresholdBoundaries}{A numeric vector with the custom time boundaries
to be used to determine the threshold temperatures for the heat wave
definition. The required format for this vector is c(start year, end
year), with the restriction that bounds must be contained within the
time boundaries of one of the two experiment subdirectories specified
by the \code{dataDirectories} argument in \code{\link{gen_hw_set}}.
The default value is 1990 to 1999.}
}
\value{
The function returns a list object outlining the file structure of
   the \code{dataFolder} directory.
}
\description{
This function parses the structure of the user-provided
directory of climate projection files to create a list of the
climate models and ensemble members included.
}
\note{
Projection, grid locations, and projection time files within the
   \code{dataFolder} directory must be comma-separated (.csv) files and
   must be named using the names specified by the arguments
   \code{coordinateFilenames}, \code{tasFilenames}, and \code{timeFilenames}.
   See the \code{futureheatwaves} vignette for more information about
   setting up the \code{dataFolder} directory.
}

