% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapCities.R
\name{map_grid_leaflet}
\alias{map_grid_leaflet}
\title{Create an interactive map of model grid}
\usage{
map_grid_leaflet(plot_model, out)
}
\arguments{
\item{plot_model}{A character string with the name of the model to plot}

\item{out}{Character string with pathname to which extreme event files were
written by \code{\link{gen_hw_set}}. Typically, this will be the same
pathname as that specified with \code{out} when running
\code{\link{gen_hw_set}}.}
}
\value{
A \code{leaflet} object with a map of grid points for the climate
   model that were used in processing extreme events for the study locations,
   with a line drawn from each study locations to the grid point used for
   it. This map can be explored interactively.
}
\description{
This function creates an interactive map of the grid points of a
climate model used for the study locations and draws lines connecting each
study city to its climate model grid point. This map is made using the
\code{leaflet} package.
}
\examples{
out <- system.file("extdata/example_results", package = "futureheatwaves")
map_grid_leaflet(plot_model = "bcc1", out = out)

}

