% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process.R
\name{processProjections}
\alias{processProjections}
\title{Create heat wave dataframe for climate projection}
\usage{
processProjections(ensemble, modelName, ensembleWriter, thresholds, global,
  custom, accumulators, reference, reference_dates)
}
\arguments{
\item{ensemble}{List with parsed information about the directory structure for
a specific ensemble member from the user-specified projections directory.
This list is a subset of the list generated by
\code{\link{acquireDirectoryStructure}}.}

\item{modelName}{Character string of climate model name (e.g., "bcc1"). This
name is generated from the subdirectory name for the climate model within
\code{dataFolder}.}

\item{ensembleWriter}{A closure created by \code{createEnsembleWriter} to
write output from this process to a file within the output directory
specified by the user with the \code{out} argument in
\code{\link{gen_hw_set}}.}

\item{thresholds}{A vector with the thresholds to use within each city
in that city's heat wave definition.These are typically automatically
determine during the run of the \code{gen_hw_set} function.}

\item{global}{An list object created by \code{\link{gen_hw_set}} that
includes user specifications (e.g., the path to the output directory, the
path to the input climate projections, the dataframe with city
locations).}

\item{custom}{An list object created by \code{\link{gen_hw_set}} that
includes user specifications (e.g., the name of the R function to
use to identify heat waves, alternative upper and lower year boundaries
for the data used to determine threshold temperatures for the heat wave
definition, alternative upper and lower year boundaries
for the projection period of the heat wave datasets being generated).}

\item{accumulators}{The closure generated by
\code{\link{createAccumulators}} that allows you to append model
information and grid location data as you process through models to
a growing list.}

\item{reference}{FALSE, if the user has not specified custom reference
boundaries through the \code{referenceBoundaries} argument in
\code{\link{gen_hw_set}}, otherwise a dataframe with the time series of
projected temperatures for the custom reference period for each study
city.}

\item{reference_dates}{A numeric vector with the start and
end years to use for the reference period}
}
\value{
This function writes every heat wave dataframe to a .csv and returns
   the ensemble member used as the reference.
}
\description{
This function, for each ensemble member, creates the heat wave dataframe and
writes it to file. It also stores the locations for each ensemble.
}

