% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IO.R
\name{readtas}
\alias{readtas}
\title{Read climate projection data}
\usage{
readtas(ensemble, global, locations)
}
\arguments{
\item{ensemble}{Character vector that includes
the file paths to (1) the latitude and longitude file; (2) the
climate projection file; and (3) the projection dates file
for the selected climate model.}

\item{global}{An list object created by \code{\link{gen_hw_set}} that
includes user specifications (e.g., the path to the output directory, the
path to the input climate projections, the dataframe with city
locations).}

\item{locations}{A numerical vector giving the column numbers that
correspond to the closest grid point location for each study
location in the temperature input data.}
}
\value{
A dataframe of climate projection data where each column
   corresponds to a climate model grid point and each row corresponds
   to a date of observation.
}
\description{
This function reads climate projection data for a climate
model into R from a locally-stored comma-separated file located within
the directory specified by the \code{dataFolder} argument of
\code{\link{gen_hw_set}}.
}

