% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{plot.boottest}
\alias{plot.boottest}
\title{Plot the bootstrap distribution of t-statistics}
\usage{
\method{plot}{boottest}(x, ...)
}
\arguments{
\item{x}{An object of type boottest}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
A plot of bootstrap t-statistics under different null hypotheses
}
\description{
Plot the bootstrap distribution of t-statistics
}
\examples{
requireNamespace("fwildclusterboot")
data(voters)
lm_fit <- lm(
proposition_vote ~ treatment + ideology1 + log_income + Q1_immigration,
  data = voters
)
boot <- boottest(lm_fit,
  B = 9999,
  param = "treatment",
  clustid = "group_id1"
)
plot(boot)
}
