% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plotCones3D}
\alias{plotCones3D}
\title{Plot a cone defined by a point in 3D.}
\usage{
plotCones3D(
  pts,
  drawPoint = TRUE,
  drawLines = TRUE,
  drawPolygons = TRUE,
  direction = 1,
  rectangle = FALSE,
  useRGLBBox = TRUE,
  ...
)
}
\arguments{
\item{pts}{A matrix with a point in each row.}

\item{drawPoint}{Draw the points defining the cone.}

\item{drawLines}{Draw lines of the cone.}

\item{drawPolygons}{Draw polygons of the cone.}

\item{direction}{Ray direction. If i'th entry is positive, consider the i'th column of \code{pts}
plus a value greater than on equal zero (minimize objective $i$). If negative, consider the
i'th column of \code{pts} minus a value greater than on equal zero (maximize objective $i$).}

\item{rectangle}{Draw the cone as a rectangle.}

\item{useRGLBBox}{Use the RGL bounding box as ray limits for the cone.}

\item{...}{Further arguments passed on the the RGL plotting functions. This must be done as
lists (see examples). Currently the following arguments are supported:
\itemize{
\item \code{argsPlot3d}: A list of arguments for \code{\link[rgl:plot3d]{rgl::plot3d}}.
\item \code{argsSegments3d}: A list of arguments for \code{\link[rgl:primitives]{rgl::segments3d}}.
\item \code{argsPolygon3d}: A list of arguments for \code{\link[rgl:polygon3d]{rgl::polygon3d}}.
}}
}
\value{
Object ids (invisible).
}
\description{
The cones are defined as the point plus R3+.
}
\examples{
\donttest{
ini3D(argsPlot3d = list(xlim = c(0,6), ylim = c(0,6), zlim = c(0,6)))
plotCones3D(c(4,4,4), drawLines = FALSE, drawPoint = TRUE,
           argsPlot3d = list(col = "red", size = 10),
           argsPolygon3d = list(alpha = 1), rectangle = TRUE)
plotCones3D(c(1,1,1), rectangle = FALSE)
plotCones3D(matrix(c(3,3,3,2,2,2), ncol = 3, byrow = TRUE))
finalize3D()

ini3D(argsPlot3d = list(xlim = c(0,6), ylim = c(0,6), zlim = c(0,6)))
plotCones3D(c(4,4,4), direction = 1)
plotCones3D(c(2,2,2), direction = -1)
plotCones3D(c(4,2,2), direction = c(1,-1,-1))
ids <- plotCones3D(c(2,2,4), direction = c(-1,-1,1))
finalize3D()
# pop3d(id = ids) # remove last cone
}
}
