% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combnC-c.R
\name{combnPrim}
\alias{combnPrim}
\title{Generate All Combinations of n Elements Taken m at a Time}
\usage{
combnPrim(x, m, simplify = TRUE)
}
\arguments{
\item{x}{vector source for combinations, or integer n for x <-
seq(n).}

\item{m}{number of elements to choose.}

\item{simplify}{logical indicating if the result should be
simplified to a matrix; if FALSE, the function returns a list.}
}
\value{
A matrix or a list.
}
\description{
Generate all combinations of the elements of x taken m
    at a time.  If x is a positive integer, returns all
    combinations of the elements of seq(x) taken m at a time.
}
\note{
The combnPrim function is a simplified version of the combn
    function.  However, combnPrim is implemented in C and is
    considerably faster than combn.
}
\examples{

x <- letters[1:20]
m <- 3

combn(x,m)
combnPrim(x,m)

combn(m,m)
combnPrim(m,m)

combn(x,m, simplify=FALSE)
combnPrim(x,m, simplify=FALSE)

system.time({ for (i in 1:100) { combnPrim(x,m) }})
system.time({ for (i in 1:100) { combn(x,m) }})

system.time({ for (i in 1:100) { combnPrim(x,m, simplify=FALSE) }})
system.time({ for (i in 1:100) { combn(x,m, simplify=FALSE) }})


}
\author{
P. T. Wallace and Søren Højsgaard
}
\seealso{
\code{\link{combn}}
}
\keyword{utilities}

