% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iModel-testadd.R
\name{testadd}
\alias{testadd}
\alias{testadd.iModel}
\alias{print.testadd}
\alias{testadd.mModel}
\title{Test addition of edge to graphical model}
\usage{
testadd(object, edge, k = 2, details = 1, ...)
}
\arguments{
\item{object}{A model; an object of class \code{iModel}.}

\item{edge}{An edge; either as a vector or as a right hand sided formula.}

\item{k}{Penalty parameter used when calculating change in AIC}

\item{details}{The amount of details to be printed; 0 surpresses all
information}

\item{\dots}{Further arguments to be passed on to the underlying functions
for testing; that is to CItable and CImvn}
}
\value{
A list
}
\description{
Performs a test of addition of an edge to a graphical model (an
\code{iModel} object).
}
\details{
Let M0 be the model and e={u,v} be an edge and let M1 be the model obtained
by adding e to M0. If M1 is decomposable AND e is contained in one clique C
only of M1 then the test is carried out in the C-marginal model. In this
case, and if the model is a log-linear model then the degrees of freedom is
adjusted for sparsity.
}
\examples{

## ## ## testadd
## ## ## 

## ## Discrete model
## ## 
data(reinis)
## A decomposable model
##
mf <- ~smoke:phys:mental + smoke:systol:mental
object <- dmod(mf, data=reinis)
testadd(object,c("systol","phys"))


## A non-decomposable model
##
mf <- ~smoke:phys + phys:mental + smoke:systol + systol:mental
object <- dmod(mf, data=reinis)
testadd(object, c("phys", "systol"))


## ## Continuous model
## ## 
data(math)
## A decomposable model
##
mf <- ~me:ve:al + al:an
object <- cmod(mf, data=math)
testadd(object, c("me", "an"))

## A non-decomposable model
##
mf <- ~me:ve + ve:al + al:an + an:me
object <- cmod(mf, data=math)
testadd(object, c("me", "al"))

}
\seealso{
\code{\link{testdelete}}
}
\author{
Søren Højsgaard, \email{sorenh@math.aau.dk}
}
\keyword{htest}
\keyword{models}
