% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sgSEMp2.R
\name{sgSEMp2}
\alias{sgSEMp2}
\title{Semi-supervised Generalized Structural Equation Modelling (gSEM) - Principle 2}
\usage{
sgSEMp2(x, predictor = NULL, response = NULL)
}
\arguments{
\item{x}{A dataframe, requiring at least 2 columns. By default its first column stores the main or primary influencing predictor, or exogenous variable e.g.., time, or a main predictor, the second column stores the response variable, and other columns store intermediate variables.}

\item{predictor}{A character string of the column name of the system predictor OR a numeric number indexing the column of the main predictor.}

\item{response}{A character string of the column name of the main response OR a numeric number indexing the column of the system response.}
}
\value{
A list of the following items:

\itemize{
\item "Graph": A network graph that contains the group and individual relationships between response and predictors determined by principle 2.
\item "res.print": A matrix. For each row, first column is the response variable, second column is the predictor, the other columns show corresponding summary information.
}
}
\description{
This function builds an gSEM model using gSEM principle 2. Principle 2 resembles the multiple regression principle in the way multiple predictors are considered simultaneously. Specifically, the first-level predictors to the system level variable, such as, Time and unit level variables, acted on the system level variable collectively by an additive model. This collective additive model can be found with a generalized stepwise variable selection (using the step() function in R, which performs variable selection on the basis of AIC) and this proceeds iteratively.
}
\details{
Data is analysed first using Principle 1 to find the best models. If needed, transformations based on the best models are applied to the predictors. Starting from the system response variable, each variable is regressed on all other variables except for the system response in an additive multiple regression model, which is reduced by a stepwise selection using stepAIC(). Then, for each selected variable, fitted regression for 6 selected functional forms and pick the best.
}
\examples{
data(acrylic)
ans <- sgSEMp2(acrylic)
ans$res.print
plot(ans)


}
\seealso{
sgSEMp1() and plot.sgSEMp2()
}

