\name{gcheckboxgroup}
\alias{.gcheckboxgroup}
\alias{addHandlerChanged.GCheckboxGroup}
\alias{gcheckboxgroup}
\alias{svalue.GCheckboxGroup}
\title{Constructor for checkbox group. A linked group of checkboxes, but not exclusive.}
\usage{
  gcheckboxgroup(items, checked = FALSE,
    horizontal = FALSE, use.table = FALSE, handler = NULL,
    action = NULL, container = NULL, ...,
    toolkit = guiToolkit())

  .gcheckboxgroup(toolkit, items, checked = FALSE,
    horizontal = FALSE, use.table = FALSE, handler = NULL,
    action = NULL, container = NULL, ...)

  \method{addHandlerChanged}{GCheckboxGroup} (obj, handler,
    action = NULL, ...)

  \method{svalue}{GCheckboxGroup} (obj, index = NULL,
    drop = NULL, ...)
}
\arguments{
  \item{items}{checkbox labels}

  \item{checked}{logical. Are values checked}

  \item{horizontal}{logical. If true displayed
  horizontally, else vertically}

  \item{use.table}{logical. If supported, and \code{TRUE}
  then uses a table widget with scrollbars}

  \item{obj}{receiver object}

  \item{handler}{A handler assigned to the default change
  signal. Handlers are called when some event triggers a
  widget to emit a signal. For each widget some default
  signal is assumed, and handlers may be assigned to that
  through \code{addHandlerChanged} or at construction time.
  Handlers are functions whose first argument, \code{h} in
  the documentation, is a list with atleast two components
  \code{obj}, referring to the object emitting the signal
  and \code{action}, which passes in user-specified data to
  parameterize the function call.}

  \item{action}{User supplied data passed to the handler
  when it is called}

  \item{container}{A parent container. When a widget is
  created it can be incorporated into the widget heirarchy
  by passing in a parent container at construction time.
  (For some toolkits this is not optional, e.g.
  \pkg{gWidgets2tcltk} or \pkg{gWidgets2WWW2}.)}

  \item{...}{These values are passed to the \code{add}
  method of the parent container, and occasionally have
  been used to sneak in hidden arguments to toolkit
  implementations. For example, when using a widget as a
  menubar object one can specify a parent argument to pass
  in parent information, similar to how the argument is
  used with gaction and the dialogs.}

  \item{toolkit}{Each widget constructor is passed in the
  toolkit it will use. This is typically done using the
  default, which will lookup the toolkit through
  \code{\link{guiToolkit}}.}

  \item{index}{NULL or logical. If \code{TRUE} and widget
  supports it an index, instead of a value will be
  returned.}

  \item{drop}{NULL or logical. If widget supports it, drop
  will work as it does in a data frame or perhaps someother
  means.}
}
\value{
  Returns an object of class \code{GCheckboxGroup} for
  which the following methods are overridden:

  \itemize{

  \item{ \code{svalue} Return the selected values or an
  empty character vector. If \code{index=TRUE}, returns
  indices of selected values.}

  \item{ \code{svalue<-} Set the selected values one of
  three ways: by label name, by a logical variable
  indicating which are selected (if ambigous, logical
  wins), if \code{index=TRUE} by the indices to select.}

  \item{ \code{[} returns labels}

  \item{ \code{[<-} set the label values. Should be able to
  shorten or lengthen list}

  }
}
\description{
  Constructor for checkbox group. A linked group of
  checkboxes, but not exclusive.

  generic for toolkit dispatch

  Change handler for a \code{GCheckboxGroup}p is called
  when any of the checkboxes changes state.

  The \code{svalue} methods refer to the selected values.
  By default these are the item values, coerced to
  characterq. When \code{index=TRUE} is specified, then the
  index is returned as an integer vector. For setting, one
  may also use a vector of logicals (which is recycled) for
  the index.
}
\examples{
if(interactive()) {
  w <- gwindow("Selection widgets")
  g <- gvbox(cont=w)

  fl <- gformlayout(cont=g)
  gcheckbox("checkbox", checked=TRUE, cont=fl, label="checkbox")
  gradio(state.name[1:4], selected=2, horizontal=TRUE, cont=fl, label="gradio")
  gcheckboxgroup(state.name[1:4], horizontal=FALSE, cont=fl, label="checkbox group")

  bg <- ggroup(cont=g)
  gbutton("ok", cont=bg, handler=function(h,...) print(sapply(fl$children, svalue)))



}
}

