% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ala_species.R
\name{ala_species}
\alias{ala_species}
\title{Species lists}
\usage{
ala_species(taxa = NULL, filters = NULL, locations = NULL)
}
\arguments{
\item{taxa}{\code{data.frame}: generated by a call to \code{\link{select_taxa}()}. This
argument also accepts a vector of unique species identifiers.}

\item{filters}{\code{data.frame}: generated by a call to \code{\link{select_filters}()}}

\item{locations}{\code{string}: generated by a call to \code{\link{select_locations}()}}
}
\value{
A \code{data.frame} of matching species.
}
\description{
While there are reasons why users may need to check every record meeting their
search criteria (i.e. using \code{\link{ala_occurrences}}), a common use case
is to simply identify which species occur in a specified region, time period,
or taxonomic group. This function returns a \code{data.frame} with one row
per species, and columns giving associated taxonomic information.
}
\details{
The primary use case of this function is to extract species-level information
given a set of criteria defined by \code{\link{select_taxa}()},
\code{\link{select_filters}()} or \code{\link{select_locations}()}. If the purpose
is simply to get taxonomic information that is not restricted by filtering,
then \code{\link{select_taxa}()} is more efficient. Similarly, if counts are
required that include filters but without returning taxonomic detail, then
\code{\link{ala_counts}()} is more efficient (see examples).
}
\examples{
\dontrun{

# Lookup genus "Heleioporus" in the ALA
select_taxa("Heleioporus")

# How many records are there for this genus?
ala_counts(select_taxa("Heleioporus"))
# or equivalently:
select_taxa("Heleioporus", counts = TRUE)

# How best to get taxonomic info on species within this genus?
# also includes a row for genus (i.e. not just species)
select_taxa("Heleioporus", children = TRUE)
# returns counts by species, but no taxonomic information
ala_counts(select_taxa("Heleioporus"), group_by = "species")
# every row is a species with associated taxonomic data
ala_species(select_taxa("Heleioporus"))
}
}
