% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show_all_ranks.R
\name{show_all_ranks}
\alias{show_all_ranks}
\title{Find valid taxonomic ranks}
\usage{
show_all_ranks()
}
\value{
An object of class \code{tbl_df} and \code{data.frame} (aka a tibble) of
available ranks
}
\description{
Return taxonomic ranks recognised by the ALA.
}
\section{Examples}{


Show a listing of all taxonomic ranks\if{html}{\out{<div class="sourceCode r">}}\preformatted{show_all_ranks()
#> # A tibble: 69 x 2
#>      id name        
#>   <int> <chr>       
#> 1     1 root        
#> 2     2 superkingdom
#> 3     3 kingdom     
#> 4     4 subkingdom  
#> # ... with 65 more rows
}\if{html}{\out{</div>}}

Use ranks with \code{\link[=galah_down_to]{galah_down_to()}} and \code{\link[=atlas_taxonomy]{atlas_taxonomy()}} to get taxonomic
trees\if{html}{\out{<div class="sourceCode r">}}\preformatted{galah_call() \%>\%
  galah_identify("fungi") \%>\%
  galah_down_to(subphylum) \%>\%
  atlas_taxonomy()
#>                        levelName
#> 1  Fungi                        
#> 2   ¦--Ascomycota               
#> 3   ¦   ¦--Pezizomycotina       
#> 4   ¦   ¦--Saccharomycotina     
#> 5   ¦   °--Taphrinomycotina     
#> 6   ¦--Basidiomycota            
#> 7   ¦   ¦--Agaricomycotina      
#> 8   ¦   ¦--Pucciniomycotina     
#> 9   ¦   ¦--Ustilaginomycotina   
#> 10  ¦   °--Wallemiomycotina     
#> 11  ¦--Mucoromycota             
#> 12  ¦   °--Glomeromycotina      
#> 13  °--Zygomycota               
#> 14      ¦--Entomophthoromycotina
#> 15      ¦--Kickxellomycotina    
#> 16      ¦--Mortierellomycotina  
#> 17      ¦--Mucoromycotina       
#> 18      °--Zoopagomycotina
}\if{html}{\out{</div>}}
}

\seealso{
This function provides a
reference that is useful when specifying the \code{down_to} argument of
\code{\link[=atlas_taxonomy]{atlas_taxonomy()}}.
}
