% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/galah_apply_profile.R
\name{galah_apply_profile}
\alias{galah_apply_profile}
\title{Apply a data quality profile}
\usage{
galah_apply_profile(...)
}
\arguments{
\item{...}{a profile name. Should be a \code{string} - the name or abbreviation
of a data quality profile to apply to the query. Valid values can be seen
using \code{show_all(profiles)}}
}
\value{
A tibble containing a valid data profile value.
}
\description{
A 'profile' is a group of filters that are pre-applied by the ALA. Using a
data profile allows a query to be filtered quickly to the most relevant or
quality-assured data that is fit-for-purpose. For example, the "ALA" profile
is designed to exclude lower quality records, whereas other profiles apply
filters specific to species distribution modelling (e.g. CDSM).
}
\details{
Note that only one profile can be loaded at a time; if multiple profiles are
given, the first valid profile is used.

For more bespoke editing of filters within a profile, use \code{\link[=galah_filter]{galah_filter()}}
}
\section{Examples}{


Apply a data profile to a query

\if{html}{\out{<div class="sourceCode r">}}\preformatted{galah_call() |> 
  galah_identify("reptilia") |>
  galah_filter(year == 2021) |>
  galah_apply_profile(ALA) |>
  atlas_counts()
#> # A tibble: 1 x 1
#>   count
#>   <int>
#> 1 29296
}\if{html}{\out{</div>}}
}

\seealso{
\code{\link[=show_all]{show_all()}} and \code{\link[=search_all]{search_all()}} to look up available data profiles.
\code{\link[=galah_filter]{galah_filter()}} can be used for more bespoke editing of individual data
profile filters.
}
