% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/atlas_counts.R
\name{atlas_counts}
\alias{atlas_counts}
\title{Return a count of records}
\usage{
atlas_counts(
  request = NULL,
  identify = NULL,
  filter = NULL,
  geolocate = NULL,
  data_profile = NULL,
  group_by = NULL,
  limit = NULL,
  type = c("record", "species"),
  refresh_cache = FALSE
)
}
\arguments{
\item{request}{optional \code{data_request} object: generated by a call to
\code{\link[=galah_call]{galah_call()}}.}

\item{identify}{\code{data.frame}: generated by a call to
\code{\link[=galah_identify]{galah_identify()}}.}

\item{filter}{\code{data.frame}: generated by a call to
\code{\link[=galah_filter]{galah_filter()}}}

\item{geolocate}{\code{string}: generated by a call to
\code{\link[=galah_geolocate]{galah_geolocate()}}}

\item{data_profile}{\code{string}: generated by a call to
\code{\link[=galah_apply_profile]{galah_apply_profile()}}}

\item{group_by}{\code{data.frame}: An object of class \code{galah_group_by},
as returned by \code{\link[=galah_group_by]{galah_group_by()}}. Alternatively a vector of field
names (see \code{search_all(fields)} and \code{show_all(fields)}.}

\item{limit}{\code{numeric}: maximum number of categories to return, defaulting to 100.
If limit is NULL, all results are returned. For some categories this will
take a while.}

\item{type}{\code{string}: one of \code{c("record", "species")}. Defaults to
"record". If "species", the number of species matching the criteria will be
returned, if "record", the number of records matching the criteria will be
returned.}

\item{refresh_cache}{\code{logical}: if set to \code{TRUE} and
\code{galah_config(caching = TRUE)} then files cached from a previous query will
be replaced by the current query}
}
\value{
An object of class \code{tbl_df} and \code{data.frame} (aka a tibble) returning:
\itemize{
\item A single number, if \code{group_by} is not specified or,
\item A summary of counts grouped by field(s), if \code{group_by} is specified
}
}
\description{
Prior to downloading data it is often valuable to have some estimate of how
many records are available, both for deciding if the query is feasible,
and for estimating how long it will take to download. Alternatively, for some kinds
of reporting, the count of observations may be all that is required, for example
for understanding how observations are growing or shrinking in particular
locations, or for particular taxa. To this end, \code{atlas_counts()} takes
arguments in the same format as \code{\link[=atlas_occurrences]{atlas_occurrences()}}, and
provides either a total count of records matching the criteria, or a
\code{data.frame} of counts matching the criteria supplied to the \code{group_by}
argument.
}
\examples{
galah_call() |>
  galah_filter(year == 2015) |>
  atlas_counts()
  
}
