% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/atlas_counts.R
\name{atlas_counts}
\alias{atlas_counts}
\alias{count.data_request}
\title{Return a count of records}
\usage{
atlas_counts(
  request = NULL,
  identify = NULL,
  filter = NULL,
  geolocate = NULL,
  data_profile = NULL,
  group_by = NULL,
  limit = NULL,
  type = c("occurrences", "species")
)

\method{count}{data_request}(x, ..., wt, sort, name)
}
\arguments{
\item{request}{optional \code{data_request} object: generated by a call to
\code{\link[=galah_call]{galah_call()}}.}

\item{identify}{\code{data.frame}: generated by a call to
\code{\link[=galah_identify]{galah_identify()}}.}

\item{filter}{\code{data.frame}: generated by a call to
\code{\link[=galah_filter]{galah_filter()}}}

\item{geolocate}{\code{string}: generated by a call to
\code{\link[=galah_geolocate]{galah_geolocate()}}}

\item{data_profile}{\code{string}: generated by a call to
\code{\link[=galah_apply_profile]{galah_apply_profile()}}}

\item{group_by}{\code{data.frame}: An object of class \code{galah_group_by},
as returned by \code{\link[=galah_group_by]{galah_group_by()}}. Alternatively a vector of field
names (see \code{search_all(fields)} and \code{show_all(fields)}.}

\item{limit}{\code{numeric}: maximum number of categories to return, defaulting to 100.
If limit is NULL, all results are returned. For some categories this will
take a while.}

\item{type}{\code{string}: one of \code{c("occurrences-count", "species-count")}.
Defaults to \code{"occurrences-count"}, which returns the number of records
that match the selected criteria; alternatively returns the number of
species. Formerly accepted arguments (\code{"records"} or \code{"species"}) are
deprecated but remain functional.}

\item{x}{An object of class \code{data_request}, created using \code{\link[=galah_call]{galah_call()}}}

\item{...}{currently ignored}

\item{wt}{currently ignored}

\item{sort}{currently ignored}

\item{name}{currently ignored}
}
\value{
An object of class \code{tbl_df} and \code{data.frame} (aka a tibble) returning:
\itemize{
\item A single number, if \code{group_by} is not specified or,
\item A summary of counts grouped by field(s), if \code{group_by} is specified
}
}
\description{
Prior to downloading data it is often valuable to have some estimate of how
many records are available, both for deciding if the query is feasible,
and for estimating how long it will take to download. Alternatively, for some kinds
of reporting, the count of observations may be all that is required, for example
for understanding how observations are growing or shrinking in particular
locations, or for particular taxa. To this end, \code{atlas_counts()} takes
arguments in the same format as \code{\link[=atlas_occurrences]{atlas_occurrences()}}, and
provides either a total count of records matching the criteria, or a
\code{data.frame} of counts matching the criteria supplied to the \code{group_by}
argument.
}
\examples{
\dontrun{
# classic syntax:
galah_call() |>
  galah_filter(year == 2015) |>
  atlas_counts()

# synonymous with:
request_data() |>
  filter(year == 2015) |>
  count() |>
  collect()
}
}
