% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/galah_config.R
\name{galah_config}
\alias{galah_config}
\title{Get or set configuration options that control galah behaviour}
\usage{
galah_config(...)
}
\arguments{
\item{\dots}{Options can be defined using the form \code{name = "value"}.
Valid arguments are:
\itemize{
\item \code{api-key} string: A registered API key (currently unused).
\item \code{atlas} string: Living Atlas to point to, Australia by default. Can be
an organisation name, acronym, or region (see \code{\link[=show_all_atlases]{show_all_atlases()}} for
admissible values)
\item \code{directory} string: the directory to use for the cache.
By default this is a temporary directory, which means that results will
only be cached
within an R session and cleared automatically when the user exits R.
The user may wish to set this to a non-temporary directory for
caching across sessions. The directory must exist on the file system.
\item \code{download_reason_id} numeric or string: the "download reason" required.
by some ALA services, either as a numeric ID (currently 0--13)
or a string (see \code{show_all(reasons)} for a list of valid ID codes and
names). By default this is NA. Some ALA services require a valid
download_reason_id code, either specified here or directly to the
associated R function.
\item \code{email} string: An email address that has been registered with the chosen
atlas. For the ALA, you can register at
\href{https://auth.ala.org.au/userdetails/registration/createAccount}{this address}.
\item \code{password} string: A registered password (GBIF only)
\item \code{run_checks} logical: should \code{galah} run checks for filters
and columns. If making lots of requests sequentially, checks can slow down
the process and lead to HTTP 500 errors, so should be turned off. Defaults
to TRUE.
\item \code{send_email} logical: should you receive an email for each query to
\code{\link[=atlas_occurrences]{atlas_occurrences()}}? Defaults to \code{FALSE}; but can be
useful in some instances, for example for tracking DOIs assigned to
specific downloads for later citation.
\item \code{username} string: A registered username (GBIF only)
\item \code{verbose} logical: should \code{galah} give verbose such as progress bars?
Defaults to FALSE.
}}
}
\value{
For \code{galah_config()}, a \code{list} of all options.
When \code{galah_config(...)} is called with arguments, nothing is returned
but the configuration is set.
}
\description{
The \code{galah} package supports large data downloads, and also
interfaces with the ALA which requires that users of some services
provide a registered email address and reason for downloading data. The
\code{galah_config} function provides a way to manage these issues as simply
as possible.
}
\examples{
\dontrun{
# To download occurrence records, enter your email in `galah_config()`. 
# This email should be registered with the atlas in question. 
galah_config(email = "your-email@email.com")
 
# Turn on caching in your session
galah_config(caching = TRUE)
 
# Some ALA services require that you add a reason for downloading data. 
# Add your selected reason using the option `download_reason_id`
galah_config(download_reason_id = 0)

# To look up all valid reasons to enter, use `show_all(reasons)`
show_all(reasons)

# Make debugging in your session easier by setting `verbose = TRUE`
galah_config(verbose = TRUE)
}
}
