% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{diet}
\alias{diet}
\title{Diet Data}
\format{
\subsection{\code{diet} A data frame with 236 rows and 7 columns:}{

\describe{
\item{id}{Subject ID.}
\item{age}{Age (standardized).}
\item{bus}{Dummy variable indicating whether the subject is a bus
driver or banking staff.}
\item{item}{Integer indicating whether the outcome is fiber intake at
time 1 (item = 1), fiber intake at time 2 (item = 2), or coronary heart
disease (item = 3).}
\item{y}{Outcome.}
\item{chd}{Dummy variable indicating whether y is an indicator for
coronary heart disease, coded as 0/1.}
\item{fiber}{Dummy variable indicating whether y is a fiber measurement
at either timepoint 1 or 2.}
\item{fiber2}{Dummy variable indicating whether y is a fiber measurement
at timepoint 2.}
}
}
}
\source{
\url{http://www.gllamm.org/books/readme.html#14.2}
}
\usage{
diet
}
\description{
Longitudinal epilepsy data from
\insertCite{morrisDietHeartPostscript1977;textual}{galamm}. This
documentation is based on Chapter 14.2 of
\insertCite{skrondalGeneralizedLatentVariable2004;textual}{galamm}, where the
dataset is used. See also
\insertCite{rabe-heskethCorrectingCovariateMeasurement2003;textual}{galamm}.
}
\references{
\insertAllCited{}
}
\seealso{
Other datasets: 
\code{\link{cognition}},
\code{\link{epilep}},
\code{\link{hsced}},
\code{\link{latent_covariates_long}},
\code{\link{latent_covariates}},
\code{\link{mresp_hsced}},
\code{\link{mresp}}
}
\concept{datasets}
\keyword{datasets}
