% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Date-generics.R, R/Date-methods.R
\docType{methods}
\name{DateRange}
\alias{DateRange}
\alias{DateRange<-}
\alias{StartDate,character-method}
\alias{EndDate,character-method}
\alias{StartDate,dateRange-method}
\alias{EndDate,dateRange-method}
\alias{StartDate,Interval-method}
\alias{EndDate,Interval-method}
\alias{StartDate,.standardQuery-method}
\alias{EndDate,.standardQuery-method}
\alias{StartDate,gaView-method}
\alias{EndDate,gaView-method}
\alias{StartDate<-,dateRange-method}
\alias{EndDate<-,dateRange-method}
\alias{StartDate<-,.standardQuery-method}
\alias{EndDate<-,.standardQuery-method}
\alias{DateRange,ANY,ANY-method}
\alias{DateRange,ANY,missing-method}
\alias{DateRange,.standardQuery,missing-method}
\alias{DateRange<-,.standardQuery-method}
\alias{DateRange,gaView,ANY-method}
\alias{DateRange<-,ANY-method}
\title{DateRange.}
\usage{
DateRange(object, endDate)

DateRange(object) <- value

\S4method{StartDate}{character}(object)

\S4method{EndDate}{character}(object)

\S4method{StartDate}{dateRange}(object)

\S4method{EndDate}{dateRange}(object)

\S4method{StartDate}{Interval}(object)

\S4method{EndDate}{Interval}(object)

\S4method{StartDate}{.standardQuery}(object)

\S4method{EndDate}{.standardQuery}(object)

\S4method{StartDate}{gaView}(object)

\S4method{EndDate}{gaView}(object)

\S4method{StartDate}{dateRange}(object) <- value

\S4method{EndDate}{dateRange}(object) <- value

\S4method{StartDate}{.standardQuery}(object) <- value

\S4method{EndDate}{.standardQuery}(object) <- value

\S4method{DateRange}{ANY,ANY}(object, endDate)

\S4method{DateRange}{ANY,missing}(object)

\S4method{DateRange}{.standardQuery,missing}(object)

\S4method{DateRange}{.standardQuery}(object) <- value

\S4method{DateRange}{gaView,ANY}(object)

\S4method{DateRange}{ANY}(object) <- value
}
\arguments{
\item{object}{The start date of the date range or a object to coerce to a
date range. Alternatively, a query object to replace the date range of.}

\item{endDate}{The end date of the date range. Alternatively, if
\code{object} is a '.query' object, then endDate is the replacement date
range.}

\item{value}{The replacement date range.}
}
\description{
Get the date range.

Set the date range.
}
\section{Methods (by class)}{
\itemize{
\item \code{character}: Coerce a character vector into a Google Analytics date
object.

\item \code{character}: Coerce a character vector into a Google Analytics date
object.

\item \code{dateRange}: Return the start dates of a date range vector

\item \code{dateRange}: Return the end dates of a date range vector

\item \code{Interval}: Return the start dates of a date range vector

\item \code{Interval}: Return the end dates of a date range vector

\item \code{.standardQuery}: Return the start dates of a query's date range vector

\item \code{.standardQuery}: Return the end dates of a query's date range vector

\item \code{gaView}: Get the date when a view first started receiving hits.

\item \code{gaView}: Get the last day a view received hits.

\item \code{dateRange}: Set a new start date for a date range.

\item \code{dateRange}: Set a new end date for a date range.

\item \code{.standardQuery}: Set a new start date for a query.

\item \code{.standardQuery}: Set a new end date for a query.

\item \code{object = ANY,endDate = ANY}: generates a date range object using the supplied
vectors of start date and end dates.

\item \code{object = ANY,endDate = missing}: Returns the date range of the given query or coerces
the supplied object into a dateRange.

\item \code{object = .standardQuery,endDate = missing}: Returns the date range of the given query.

\item \code{.standardQuery}: Modify the date range of the given query.

\item \code{object = gaView,endDate = ANY}: Returns the maximum date range of when a view has been
receiving hits.

\item \code{ANY}: Change the date range of the date range object using
the dates supplied in a vector of length 2, where the first element is the
start date and second being the end date.
}}

\seealso{
Other date range functions: \code{\link{Cohort}},
  \code{\link{EndDate}}, \code{\link{StartDate}}
}
