% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Query-generics.R, R/GaView-methods.R
\docType{methods}
\name{ga_view_selector}
\alias{ga_view_selector}
\alias{GaView}
\alias{GaView<-}
\alias{GaView,gaProperty,missing-method}
\alias{GaView,gaAccount,missing-method}
\alias{GaView,ANY,missing-method}
\alias{GaView,.query,missing-method}
\alias{GaView,.query,ANY-method}
\alias{GaView<-,.query-method}
\title{ga_view_selector.}
\usage{
ga_view_selector(creds = GoogleApiCreds(), with_gui = FALSE)

GaView(object, value)

GaView(object) <- value

\S4method{GaView}{gaProperty,missing}(object)

\S4method{GaView}{gaAccount,missing}(object)

\S4method{GaView}{ANY,missing}(object)

\S4method{GaView}{.query,missing}(object)

\S4method{GaView}{.query,ANY}(object, value)

\S4method{GaView}{.query}(object) <- value
}
\arguments{
\item{creds}{Optional. An OAuth2.0 credentials object to use for the request.}

\item{with_gui}{Optional. Boolean value indicating whether to use a GUI for
the menu. Default is FALSE.}

\item{object}{An object to coerce to a gaView class object or to get the
gaView of, such as a query, default view of a web property, or the default
view of the first web property in a Google Analytics account.}

\item{value}{The optional replacement view if the object supplied is a query,
in which case GaView will return the modified query.}
}
\value{
a gaView object.
}
\description{
GaView A menu user-interface for selecting a Google Analytics view.

Get the viewId of the query

Set the viewId for the query.
}
\section{Methods (by class)}{
\itemize{
\item \code{object = gaProperty,value = missing}: Select the default view of the property

\item \code{object = gaAccount,value = missing}: Selects the first property of the account, which is then
used to select a view (as above).

\item \code{object = ANY,value = missing}: Returns the ID of the supplied view, or the first view
within the supplied property or the first view within the first property of
the supplied account, or coerce a numeric or character into a viewId.

\item \code{object = .query,value = missing}: gets the view ID of the supplied query

\item \code{object = .query,value = ANY}: Set the view of a query, returning the query with the updated view applied.

\item \code{.query}: Replaces the view being used by a query.
}}

