\name{MCMCgrm}
\alias{MCMCgrm}
\title{Mixed modeling with genetic relationship matrices}
\usage{MCMCgrm(model,prior,data,GRM,eps=0,n.thin=10,n.burnin=3000,n.iter=13000,...)}

\description{
Mixed modeling with genomic relationship matrix. This is appropriate with relationship
matrix derived from family structures or unrelated individuals based on whole genome data.
}
\arguments{
 \item{model}{statistical model}
 \item{prior}{a list of priors for parameters in the model above}
 \item{data}{a data.frame containing outcome and covariates}
 \item{GRM}{a relationship matrix}
 \item{eps}{a small number added to the diagonal of the a nonpositive definite GRM}
 \item{n.thin}{thinning parameter in the MCMC}
 \item{n.burnin}{the number of burn-in's}
 \item{n.iter}{the number of iterations}
 \item{...}{other options as appropriate for MCMCglmm}
}

\details{
The function was created to address a number of issues involving mixed modelling with
family data or population sample with whole genome data. First, the implementaiton
will shed light on the uncertainty involved with polygenic effect in that posterior
distributions can be obtained. Second, while the model can be used with the MCMCglmm
package there is often issues with the specification of pedigree structures but this
is less of a problem with genetic relationship matrices. We can use established
algorithms to generate kinship or genomic relationship matrix as input to the MCMCglmm
function. Third, it is more intuitive to specify function arguments in line with other
packages such as R2OpenBUGS, R2jags or glmmBUGS. In addition, our experiences of tuning
the model would help to reset the input and default values.
}

\value{
The returned value is an object as generated by MCMCglmm.
}

\section{References}{
Hadfield JD (2010). MCMC Methods for multi-response generalized linear mixed models:
The MCMCglmm R Package, J Stat Soft 33(2):1-22, http://www.jstatsoft.org/v33/i02/.
}

\examples{
\dontrun{
### with kinship
 
# library(kinship) 
# fam <- with(l51,makefamid(id,fid,mid))
# s <-with(l51, makekinship(fam, id, fid, mid))
# K <- as.matrix(s)*2   

### with gap

s <- kin.morgan(l51)
K <- with(s,kin.matrix*2)
prior <- list(R=list(V=1, nu=0.002), G=list(G1=list(V=1, nu=0.002)))
m <- MCMCgrm(qt~1,prior,l51,K)
save(m,file="l51.m")
pdf("l51.pdf")
plot(m)
dev.off()
}
}
\author{Jing Hua Zhao}
\keyword{htest}
