% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gapfill.R
\docType{data}
\name{ndvi}
\alias{ndvi}
\title{NDVI Data from Alaska}
\format{Numeric array with 4 dimensions. As indicated by the dimnames of the array:
\itemize{
\item{dim 1:} {longitude,}
\item{dim 2:} {latitude,}
\item{dim 3:} {day of the year,}
\item{dim 4:} {year.}
}
The values are NDVI values, and hence, between 0 and 1. Missing values are encoded as \code{NA}.}
\source{
The actual MOD13A data product is available from NASA EOSDIS Land Processes DAAC,
USGS Earth Resources Observation and Science (EROS) Center, Sioux Falls, South Dakota \url{https://lpdaac.usgs.gov}.
MODIS data can be downloaded with the R package MODIS \url{https://r-forge.r-project.org/projects/modis/}.
}
\usage{
ndvi
}
\description{
The dataset was created to test gap-fill algorithms.
It mimics a subset of the MODIS NDVI data (product MOD13A1) in the region of Alaska.
The data product features one image per 16-day time interval, i.e., 24 images per year.  
The indicated images (see \code{Image(ndvi)}) were downloaded and stored as a 4 dimensional array.
Its dimensions correspond to longitude, latitude, day of the year, and year.
}
\examples{
str(ndvi)
Image(ndvi)
}

