#require(testthat); library("gapfill", lib.loc = "../../../lib/")
context("test-Gapfill")

test_that("Gapfill demo",{
    data <- ndvi[,,2:4,2:4]


    expect_message(fill <- Gapfill(data)$fill,
                  "data has 3969 values: 3301 \\(83.2%\\) observed,\n                       668 \\(16.8%\\) missing,\n                       668 \\(16.8%\\) to predict.\n")
                     
   ref <- c(0.5174, 0.4835, 0.4992, 0.4933, 0.5401, 0.5348, 0.5484, 0.5189, 
0.5161, 0.5044, 0.5449, 0.5391, 0.5376, 0.5401, 0.5599, 0.5784, 
0.5606, 0.5794, 0.5618, 0.549, 0.5527, 0.528, 0.5639, 0.5186, 
0.5327, 0.5046, 0.5117, 0.5283, 0.5359, 0.5265, 0.5484, 0.5316, 
0.5475, 0.5387, 0.5026, 0.5554, 0.5165, 0.5469, 0.5327, 0.5173, 
0.5194, 0.5205, 0.5114, 0.5049, 0.6921, 0.6417, 0.6258, 0.5182, 
0.5268, 0.5145, 0.5119, 0.6025, 0.6023, 0.6451, 0.6608, 0.6474, 
0.1218, 0.6017, 0.5877, 0.5938, 0.5896, 0.5986, 0.5624, 0.5225, 
0.6061, 0.6154, 0.6206, 0.538, 0.5798, 0.5975, 0.483, 0.3553, 
0.106, 0.1356, 0.5996, 0.6154, 0.6068, 0.6003, 0.5892, 0.5627, 
0.4892, 0.4969, 0.5023, 0.4835, 0.5152, 0.5015, 0.5026, 0.5634, 
0.589, 0.5513, 0.5566, 0.5488, 0.498, 0.5086, 0.5359, 0.4947, 
0.513, 0.5157, 0.5154, 0.5118, 0.5147, 0.4978, 0.5092, 0.5193, 
0.517, 0.53, 0.5105, 0.5714, 0.5994, 0.5891, 0.5479, 0.5, 0.4909, 
0.5048, 0.5172, 0.5265, 0.5139, 0.5419, 0.5306, 0.5454, 0.5418, 
0.5147, 0.51, 0.5225, 0.4955, 0.5066, 0.4783, 0.55, 0.5435, 0.5617, 
0.5341, 0.5305, 0.575, 0.5799, 0.6121, 0.5891, 0.5742, 0.5238, 
0.5259, 0.5112, 0.5139, 0.5094, 0.4944, 0.4971, 0.5021, 0.5086, 
0.521, 0.5484, 0.5463, 0.5306, 0.5619, 0.5345, 0.5191, 0.474, 
0.4882, 0.5132, 0.5639, 0.5304, 0.5082, 0.5171, 0.5433, 0.5166, 
0.5481, 0.5154, 0.4917, 0.5335, 0.5291, 0.501, 0.4922, 0.5021, 
0.5027, 0.5031, 0.4912, 0.4912, 0.5, 0.4662, 0.513, 0.5086, 0.5439, 
0.534, 0.5404, 0.56, 0.5291, 0.5154, 0.5328, 0.4734, 0.4885, 
0.48, 0.503, 0.4896, 0.4752, 0.4971, 0.5097, 0.5115, 0.5576, 
0.4911, 0.5161, 0.5591, 0.5358, 0.5429, 0.4597, 0.4793, 0.4903, 
0.509, 0.5074, 0.4967, 0.4847, 0.4967, 0.5123, 0.4974, 0.5013, 
0.498, 0.5123, 0.5082, 0.5395, 0.5772, 0.4417, 0.4627, 0.452, 
0.4895, 0.4881, 0.4886, 0.5082, 0.5334, 0.5033, 0.4896, 0.4862, 
0.4904, 0.5129, 0.5154, 0.5434, 0.5611, 0.5449, 0.5651, 0.515, 
0.4517, 0.4686, 0.4963, 0.4941, 0.5121, 0.522, 0.5307, 0.5221, 
0.4562, 0.5129, 0.5382, 0.5382, 0.5125, 0.4859, 0.5577, 0.5401, 
0.5024, 0.543, 0.515, 0.4834, 0.5006, 0.4966, 0.5089, 0.5131, 
0.5121, 0.4965, 0.4476, 0.4553, 0.4488, 0.4939, 0.5068, 0.4816, 
0.483, 0.4852, 0.5604, 0.5286, 0.4978, 0.5539, 0.531, 0.5184, 
0.5112, 0.5125, 0.5014, 0.4891, 0.4968, 0.4632, 0.4674, 0.4323, 
0.4288, 0.4335, 0.4388, 0.4708, 0.5581, 0.5765, 0.6183, 0.5994, 
0.6213, 0.6343, 0.6095, 0.6081, 0.6284, 0.6953, 0.6971, 0.6904, 
0.6906, 0.6709, 0.6804, 0.6813, 0.69, 0.6829, 0.681, 0.6687, 
0.6595, 0.7472, 0.692, 0.6792, 0.6774, 0.6672, 0.6771, 0.6724, 
0.6667, 0.6676, 0.6674, 0.6769, 0.6811, 0.6715, 0.6882, 0.6779, 
0.6735, 0.6752, 0.6834, 0.6688, 0.6972, 0.6797, 0.7078, 0.6988, 
0.7209, 0.336, 0.6807, 0.6741, 0.6751, 0.6575, 0.6856, 0.7248, 
0.6562, 0.5671, 0.4942, 0.3961, 0.5152, 0.661, 0.6663, 0.6503, 
0.6672, 0.6625, 0.6682, 0.6961, 0.7043, 0.6805, 0.6782, 0.7169, 
0.7082, 0.6794, 0.6649, 0.6733, 0.676, 0.6746, 0.6721, 0.681, 
0.6737, 0.69, 0.6868, 0.6754, 0.6798, 0.6817, 0.6833, 0.6735, 
0.6673, 0.6746, 0.6547, 0.6617, 0.6418, 0.7021, 0.7069, 0.6906, 
0.6809, 0.6682, 0.666, 0.6676, 0.6589, 0.6573, 0.662, 0.6732, 
0.6802, 0.6941, 0.69, 0.6952, 0.6819, 0.6755, 0.6791, 0.6933, 
0.6756, 0.6596, 0.6847, 0.6759, 0.6777, 0.6811, 0.6598, 0.6426, 
0.673, 0.6887, 0.7013, 0.6828, 0.6744, 0.6813, 0.7273, 0.7482, 
0.6751, 0.6795, 0.7043, 0.6786, 0.6592, 0.6593, 0.6797, 0.6816, 
0.6676, 0.6782, 0.6639, 0.6624, 0.673, 0.6689, 0.6691, 0.6715, 
0.672, 0.6438, 0.6362, 0.6569, 0.6612, 0.6698, 0.6828, 0.6929, 
0.7029, 0.6924, 0.6832, 0.64, 0.6497, 0.6659, 0.6754, 0.6755, 
0.6948, 0.6884, 0.6702, 0.6922, 0.6795, 0.6759, 0.66, 0.6622, 
0.6749, 0.671, 0.6814, 0.6834, 0.6829, 0.6841, 0.6581, 0.6946, 
0.684, 0.6775, 0.683, 0.6867, 0.6764, 0.6618, 0.6656, 0.6814, 
0.6764, 0.6935, 0.7244, 0.7547, 0.684, 0.6912, 0.7071, 0.7163, 
0.711, 0.7157, 0.7234, 0.7245, 0.7238, 0.7137, 0.5642, 0.5782, 
0.4921, 0.5331, 0.6679, 0.6728, 0.6439, 0.6262, 0.6396, 0.6421, 
0.6514, 0.6543, 0.6587, 0.6606, 0.6716, 0.7027, 0.7399, 0.7617, 
0.7475, 0.4389, 0.5384, 0.3841, 0.4055, 0.3929, 0.7325, 0.7033, 
0.7022, 0.7005, 0.7518, 0.7401, 0.6875, 0.6867, 0.6853, 0.6947, 
0.6957, 0.6844, 0.6741, 0.6972, 0.7087, 0.7049, 0.7015, 0.6993, 
0.7212, 0.7298, 0.7366, 0.7053, 0.6669, 0.6736, 0.6943, 0.697, 
0.6984, 0.6981, 0.6864, 0.6899, 0.6765, 0.662, 0.6898, 0.6937, 
0.7049, 0.7017, 0.7418, 0.6769, 0.6605, 0.68, 0.6936, 0.6996, 
0.7174, 0.6985, 0.6757, 0.6779, 0.7019, 0.7186, 0.702, 0.7, 0.6772, 
0.6902, 0.6946, 0.6884, 0.6837, 0.6968, 0.6928, 0.6931, 0.6961, 
0.6947, 0.6813, 0.6831, 0.6896, 0.708, 0.7152, 0.7186, 0.7083, 
0.7128, 0.6656, 0.6731, 0.694, 0.7164, 0.7052, 0.6951, 0.7041, 
0.6942, 0.7171, 0.7012, 0.692, 0.6777, 0.6901, 0.7004, 0.6946, 
0.6999, 0.7086, 0.6993, 0.6618, 0.7309, 0.7093, 0.6983, 0.709, 
0.7094, 0.6975, 0.6831, 0.6993, 0.7102, 0.7004, 0.6995, 0.7146, 
0.6473, 0.5199, 0.6292, 0.6086, 0.6381, 0.5974, 0.6101, 0.6164, 
0.5966, 0.6076, 0.6109, 0.6173, 0.6029, 0.6106, 0.6315, 0.6254, 
0.6099, 0.6166, 0.6455, 0.6316, 0.5838, 0.5751, 0.596, 0.6728, 
0.6825, 0.6727, 0.6577, 0.671, 0.6674, 0.6474, 0.6824, 0.693, 
0.6301, 0.6577, 0.7057, 0.6963, 0.6478, 0.6178, 0.6104, 0.6186, 
0.6454, 0.6531, 0.6392, 0.6525, 0.6456, 0.6525, 0.664, 0.6513, 
0.6696, 0.6544, 0.6067, 0.6874, 0.6637, 0.6503, 0.6646, 0.6642, 
0.649, 0.6285, 0.6314, 0.6094, 0.6637, 0.6511, 0.6503, 0.6672)


    expect_equal(fill[is.na(data)], ref, tolerance=1e-4)
})


test_that("Gapfill prediction interval",{
   toFill <- c(1741L, 1785L, 1809L, 1816L, 1887L, 1888L, 1919L, 1939L, 2107L, 
               2124L, 2126L, 2131L, 2132L, 2133L, 2159L, 2193L, 2283L, 2405L, 
               2466L, 2513L, 2577L, 2741L, 2845L, 2990L, 3600L, 3601L, 3611L, 
               3724L, 3778L, 3858L, 3861L, 3932L, 4653L, 5035L, 5107L, 5108L, 
               5180L, 5222L, 5224L, 5293L, 5349L, 5359L, 5443L, 5482L, 5527L, 
               5573L, 5582L, 5596L, 6694L, 6846L)

   ref.pred <- c(0.6886, 0.4716, 0.479, 0.4279, 0.4646, 0.4759, 8e-04, 0.4867, 
0.4318, 0.4212, 0.4203, 0.4293, 0.4298, 0.4185, 0.4326, 0.375, 
0.523, 0.5198, 0.5667, 0.5264, 0.5278, 0.661, 0.6445, 0.6923, 
0.4971, 0.497, 0.4831, 0.4545, 0.4485, 0.4865, 0.5192, 0.4862, 
0.6623, 0.4371, 0.6952, 0.716, 0.7008, 0.6843, 0.7131, 0.424, 
0.4868, 0.4562, 0.5438, 0.5163, 0.5147, 0.5202, 0.5253, 0.4763, 
0.6889, 0.6511)
   ref.lo <- c(0.6216, 0.4392, 0.4692, 0.3491, 0.4379, 0.4497, -0.033, 0.4805, 
0.393, 0.366, 0.3878, 0.3685, 0.4085, 0.3905, 0.3905, 0.3445, 
0.4228, 0.4016, 0.4761, 0.3975, 0.3869, 0.5172, 0.5142, 0.5422, 
0.4349, 0.4352, 0.4264, 0.4152, 0.3589, 0.3983, 0.453, 0.4398, 
0.5544, 0.3885, 0.5982, 0.6452, 0.6219, 0.6032, 0.6369, 0.4061, 
0.4505, 0.4196, 0.4826, 0.4235, 0.4239, 0.4255, 0.4541, 0.3685, 
0.6579, 0.6234)
   ref.up <- c(0.7454, 0.623, 0.6886, 0.6118, 0.6393, 0.6381, 0.4627, 0.6513, 
0.5874, 0.5897, 0.5754, 0.5818, 0.5819, 0.5772, 0.5882, 0.545, 
0.7036, 0.7153, 0.7819, 0.7058, 0.7106, 0.7216, 0.701, 0.7356, 
0.6144, 0.6304, 0.6089, 0.5857, 0.5892, 0.5982, 0.632, 0.6451, 
0.7387, 0.5842, 0.716, 0.7439, 0.7206, 0.704, 0.7373, 0.678, 
0.6419, 0.6247, 0.7061, 0.6343, 0.6631, 0.6421, 0.62, 0.5826, 
0.7577, 0.7112)


   fill <- Gapfill(ndvi, nPredict = 3, subset = toFill, predictionInterval = TRUE)$fill
   pred <- fill[toFill]
   lo <- fill[toFill + length(ndvi)]
   up <- fill[toFill + 2*length(ndvi)]
   expect_identical(pred, fill[,,,,1][!is.na(fill[,,,,2])]) 
   expect_identical(lo, fill[,,,,2][!is.na(fill[,,,,2])])
   expect_identical(up, fill[,,,,3][!is.na(fill[,,,,3])])
   expect_true(all(lo <= pred))
   expect_true(all(pred <= up))
   expect_equal(pred, ref.pred, tolerance = 1e-4)
   expect_equal(lo, ref.lo, tolerance = 1e-4)
   expect_equal(up, ref.up, tolerance = 1e-4)
})


test_that("Gapfill args",{
  expect_error(Gapfill(),
               "argument \"data\" is missing, with no default")
  expect_error(Gapfill(matrix(1)),
               "identical\\(length\\(dim\\(data\\)\\), 4L\\) is not TRUE")
  expect_error(Gapfill(array(TRUE)),
               "identical\\(length\\(dim\\(data\\)\\), 4L\\) is not TRUE")
  expect_error(Gapfill(array(1, c(1,2,3,4,5))),
               "identical\\(length\\(dim\\(data\\)\\), 4L\\) is not TRUE")

  data <- ndvi[,,1:2,1:2]
  expect_error(Gapfill(data = data, fnSubset = 1),
               "is.function\\(fnSubset\\) is not TRUE")
  expect_error(Gapfill(data = data, fnSubset = function(x) x),
               "all\\(names\\(fnSubset_formals\\)\\[1:3\\] == c\\(\"data\", \"mp\", \"i\"\\)\\) is not TRUE")
  expect_error(Gapfill(data = data, fnSubset = function(data, mp, k) x),
               "all\\(names\\(fnSubset_formals\\)\\[1:3\\] == c\\(\"data\", \"mp\", \"i\"\\)\\) is not TRUE")
  expect_equal(Gapfill(data = data,
                       fnSubset = function(data, mp, i)
                                  array(1, c(1,1,1,1)))$fill,
               data)

  expect_error(Gapfill(data = data, fnPredict = 1),
               "is.function\\(fnPredict\\) is not TRUE")
  expect_error(Gapfill(data = data, fnPredict = function(x) x),
               "all\\(names\\(fnPredict_formals\\)\\[1:2\\] == c\\(\"a\", \"i\"\\)\\) is not TRUE")
  expect_error(Gapfill(data = data, fnPredict = function(n, k) x),
               "all\\(names\\(fnPredict_formals\\)\\[1:2\\] == c\\(\"a\", \"i\"\\)\\) is not TRUE")
  expect_equal(Gapfill(data = data, fnPredict = function(a, i) NA)$fill,
               data)

  expect_error(Gapfill(data = data, iMax = TRUE),
               "is.numeric\\(iMax\\) is not TRUE")
  expect_error(Gapfill(data = data, iMax = c(1, 1)),
               "identical\\(length\\(iMax\\), 1L\\) is not TRUE")
  expect_error(Gapfill(data = data, iMax = -1),
               "iMax >= 0L is not TRUE")

  expect_error(Gapfill(data = data, nPredict = TRUE),
               "is.numeric\\(nPredict\\) is not TRUE")
  expect_error(Gapfill(data = data, nPredict = c(1, 1)),
               "identical\\(length\\(nPredict\\), 1L\\) is not TRUE")
  expect_error(Gapfill(data = data, nPredict = -1),
               "nPredict >= 1L is not TRUE")

  expect_error(Gapfill(data = data, subset = "a"),
               "subset\\[1\\] == \"missings\" || \\(identical\\(dim\\(subset\\), dim\\(data\\)\\) &&  .... is not TRUE")
  expect_error(Gapfill(data = data, subset = c(1, 1)),
               "subset\\[1\\] == \"missings\" || \\(identical\\(dim\\(subset\\), dim\\(data\\)\\) &&  .... is not TRUE")
  expect_error(Gapfill(data = data,
                       subset = c(154, 155, 155.5)),
               "The values\\(s\\) 154, 155.5 of argument \"subset\" do not match missing values of \"data\".")

   expect_error(Gapfill(data = data,
                       subset = c(8, 8)),
               "Argument \"subset\" contains duplicated values.")
  expect_equal(Gapfill(data = data, subset = 155)$fill[155],
               0.1527, tolerance = 1e-3)
  
  
  expect_error(Gapfill(data = data, clipRange = TRUE),
               "is.numeric\\(clipRange\\) is not TRUE")
  expect_error(Gapfill(data = data, clipRange = 1),
               "identical\\(length\\(clipRange\\), 2L\\) is not TRUE")
  expect_error(Gapfill(data = data, clipRange = c(5,4)),
               "clipRange\\[1\\] < clipRange\\[2\\] is not TRUE")

  expect_error(Gapfill(data = data, dopar = c(1)),
               "is.logical\\(dopar\\) is not TRUE")
  expect_error(Gapfill(data = data, dopar = c(TRUE, TRUE)),
               "identical\\(length\\(dopar\\), 1L\\) is not TRUE")

  expect_error(Gapfill(data = data, verbose = 1),
               "is.logical\\(verbose\\) is not TRUE")
  expect_error(Gapfill(data = data, verbose = c(TRUE, TRUE)),
               "identical\\(length\\(verbose\\), 1L\\) is not TRUE")


  ## user defined fnSubset with more arguements
  expect_error(Gapfill(data = data, notExtistent = 1),
               "is/are not used by fnSubset\\(\\) or fnPredict\\(\\)")
  fnS <- function(data, mp, i, e) e
  expect_error(Gapfill(data = data, fnSubset = fnS),
               "argument \"e\" is missing, with no default")

  ## maybe more for checking if fnSubset() and fnPredict() work together.


  
})

