% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/credentials_service_account.R
\name{check_is_service_account}
\alias{check_is_service_account}
\title{Check for a service account}
\usage{
check_is_service_account(path, hint, call = caller_env())
}
\arguments{
\item{path}{JSON identifying the service account, in one of the forms
supported for the \code{txt} argument of \code{\link[jsonlite:fromJSON]{jsonlite::fromJSON()}} (typically, a
file path or JSON string).}

\item{hint}{The relevant function to call for configuring an OAuth client.}

\item{call}{The execution environment of a currently running
function, e.g. \code{call = caller_env()}. The corresponding function
call is retrieved and mentioned in error messages as the source
of the error.

You only need to supply \code{call} when throwing a condition from a
helper function which wouldn't be relevant to mention in the
message.

Can also be \code{NULL} or a \link[rlang:topic-defuse]{defused function call} to
respectively not display any call or hard-code a code to display.

For more information about error calls, see \ifelse{html}{\link[rlang:topic-error-call]{Including function calls in error messages}}{\link[rlang:topic-error-call]{Including function calls in error messages}}.}
}
\value{
Nothing. Exists purely to throw an error.
}
\description{
This pre-checks information provided to a high-level, user-facing auth
function, such as \code{googledrive::drive_auth()}, before passing the user's
input along to \code{\link[=token_fetch]{token_fetch()}}, which is designed to silently swallow errors.
Some users are confused about the difference between an OAuth client and a
service account and they provide the (path to the) JSON for one, when the
other is what's actually expected.
}
\keyword{internal}
