% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gasfluxes.R
\name{gasfluxes}
\alias{gasfluxes}
\title{Flux calculation}
\usage{
gasfluxes(dat, .id = "ID", .V = "V", .A = "A", .times = "time",
  .C = "C", methods = c("linear", "robust linear", "HMR", "NDFE"),
  k_HMR = log(1.5), k_NDFE = log(0.01), verbose = TRUE,
  plot = TRUE, select, maxiter = 100, ...)
}
\arguments{
\item{dat}{a data.frame or data.table with data from flux measurements.}

\item{.id}{character vector specifying the columns to be used as ID, multiple ID columns are possible.}

\item{.V}{character specifying the column containing chamber volume values.}

\item{.A}{character specifying the column containing chamber area values.}

\item{.times}{character specifying the column containing chamber closing time values.}

\item{.C}{character specifying the column containing concentration values.}

\item{methods}{character; which methods to use for flux estimation. See details for available methods.}

\item{k_HMR}{starting value for \code{\link{HMR.fit}}.}

\item{k_NDFE}{starting value for \code{\link{NDFE.fit}}.}

\item{verbose}{logical; print progress messages?}

\item{plot}{create plots if TRUE (the default). The IDs are used as file names and should thus not include characters that are not allowed in file names, such as \code{/} or \code{=}. A directory "pics"  is created in the working directory if it doesn't exist. The plots are only intended to facilitate quick checking, not for publication quality graphs.}

\item{select}{deprecated; please use function \code{\link{selectfluxes}}.}

\item{maxiter}{see \code{\link{nls.control}}}

\item{\dots}{further parameters}
}
\value{
A data.table with the results of the flux calculation. See the documentation of the fitting functions for details. 
 If a selection algorithm has been specified, the last columns are the selected flux estimate, the corresponding standard error and p-value and the method with which the selected flux was estimated.
}
\description{
A wrapper function for convenient flux calculation.
}
\details{
Available methods are
\tabular{ll}{
"linear":\tab \code{\link{lin.fit}}\cr
"robust linear":\tab \code{\link{rlin.fit}}\cr
"HMR":\tab \code{\link{HMR.fit}}\cr
"original HMR":\tab \code{\link{HMR.orig}}\cr
"NDFE":\tab \code{\link{NDFE.fit}}\cr
}
Specifying other methods results in an error. 

The default starting values for "HMR" and "NDFE", \eqn{k = log(\kappa)} and \eqn{k = log(\tau)}, resp., assume that time is in hours. If you use a different time unit, you should adjust them accordingly.
Note that \code{nls} is used internally by these functions and thus they should not be used with artificial "zero-residual" data.

The input data.frame or data.table should be in the following format:

\preformatted{
   serie        V A      time         C
1:    ID1 0.522625 1 0.0000000 0.3317823
2:    ID1 0.522625 1 0.3333333 0.3304053
3:    ID1 0.522625 1 0.6666667 0.3394311
4:    ID1 0.522625 1 1.0000000 0.4469102
5:    ID2 0.523625 1 0.0000000 0.4572708
}

However, more than one ID column are possible. E.g., the first ID column could be the plot and a second ID column could be the date. Keep in mind that the combination of IDs must be a unique identifier for each flux measurement.

Units of the output depend on input units. 
It's recommended to use [V] = m^3, [A] = m^2, [time] = h, [C] = [mass or mol]/m^3, which results in [f0] = [mass or mol]/m^2/h.
Since all algorithms use V/A, A can be input as 1 and V as the chamber height.
}
\examples{
\dontrun{
#compare result of original HMR with plinear HMR
data(fluxMeas)
res <- gasfluxes(fluxMeas[1:400,], 
                 .id = "serie", .V = "V", .A = "A",
                 .times = "time", .C = "C",
                 methods = c("HMR", "original HMR"), verbose = TRUE)
                 
#number of successful fits
res[, sum(!is.na(HMR.kappa))]
res[, sum(!is.na(original.HMR.kappa))]

#Do the results differ?
plot(res[["HMR.f0"]], res[["original.HMR.f0"]])
abline(0, 1)


res <- gasfluxes(fluxMeas, 
                 .id = "serie", .V = "V", .A = "A",
                 .times = "time", .C = "C",
                 methods = "HMR", verbose = TRUE)
# Error: time not sorted in flux ID ID556. 
# Investigate the problem:
fluxMeas[serie \%in\% c("ID555", "ID556", "ID557")]
#    serie        V A      time         C
# 1: ID555 0.551625 1 0.0000000 0.3884388
# 2: ID555 0.551625 1 0.3333333 0.4125270
# 3: ID555 0.551625 1 0.6666667 0.3714207
# 4: ID555 0.551625 1 1.0000000 0.3735092
# 5: ID556 0.524250 1 0.0000000 0.3638239
# 6: ID556 0.524250 1 0.3333333 0.3520481
# 7: ID556 0.524250 1 0.6666667 0.3551644
# 8: ID557 0.528375 1 0.0500000 0.3954601
# 9: ID556 0.524250 1 0.0000000 0.3839834
#10: ID557 0.528375 1 0.3333333 0.3967269
#11: ID557 0.528375 1 0.6666667 0.3764967
#12: ID557 0.528375 1 1.0000000 0.3973055

# some mixup of IDs and times
# usually an input or Excel error during data preparation
# investigate and fix
} 

}
\seealso{
\code{\link{selectfluxes}} for flux selection
}
