% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HPFVN.R
\name{HPFVN}
\alias{HPFVN}
\title{High Pass Filter Von Neumann Estimator.}
\usage{
HPFVN(wcn, evalues, b)
}
\arguments{
\item{wcn}{Noisy wavelet coefficients.}

\item{evalues}{Laplacian spectrum.}

\item{b}{Parameter that control the number of scales.}
}
\description{
Graph extension of the Von Neummann variance estimator using finest scale coefficients.
}
\examples{
data(grid1)
A <- grid1$sA
L <- laplacian_mat(A)
x <- grid1$xy[ ,1]
n <- length(x)
val1 <- eigensort(L)
evalues <- val1$evalues
evectors <- val1$evectors
f <- sin(x)
sigma <- 0.1
noise <- rnorm(n, sd = sigma)
y <- f + noise
b <- 2
wcn <- forward_sgwt(y, evalues, evectors, b=b)
sigma^2
HPFVN(wcn, evalues, b)
}
\references{
von Neumann, J. (1941). Distribution of the ratio of the mean square successive difference to the variance. \emph{Ann. Math. Statistics}, 35(3), 433--451.

de Loynes, B., Navarro, F., Olivier, B. (2021). Data-driven thresholding in denoising with Spectral Graph Wavelet Transform. Journal of Computational and Applied Mathematics, Vol. 389.
}
\seealso{
\code{\link{GVN}}
}
