% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_gaussian_volume.R
\name{compute_gaussian_volume}
\alias{compute_gaussian_volume}
\title{Compute volume under 2D gaussian}
\usage{
compute_gaussian_volume(X_var, Y_var)
}
\arguments{
\item{X_var}{numeric value of the x-axis variance}

\item{Y_var}{numeric value of the y-axis variance}
}
\value{
A numeric value indicating the computed volume
}
\description{
Compute volume under 2D gaussian
}
\details{
Volume under the 2D gaussian is computed as:
\code{2 * pi * sqrt(abs(X_var)) * sqrt(abs(Y_var))}
}
\examples{
library(gaussplotR)

compute_gaussian_volume(5, 3) #24.33467
}
\author{
Vikram B. Baliga
}
