% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_peaks.R
\name{plot_peak}
\alias{plot_peak}
\title{Peak Plot}
\usage{
plot_peak(
  peaks,
  data,
  title = "Intensity with Peaks",
  circlecolor = "red",
  circlesize = 5
)
}
\arguments{
\item{peaks}{a \emph{data.frame} object. A data frame with 4 columns (Time,
X, Y, Peak), ideally the output from either thr_peaks() or top_peaks().}

\item{data}{a \emph{list} object. Data extracted from a cdf file,
ideally the output from extract_data(). Provides the
background GCxGC plot, created with plot_chr().}

\item{title}{a \emph{string} object. Title placed at the top of the plot.
Default title "Intensity with Peaks".}

\item{circlecolor}{a \emph{string} object. The desired color of the circles
which indicate the peaks. Default color red.}

\item{circlesize}{a \emph{double} object. The size of the circles which
indicate the peaks. Default size 5.}
}
\value{
A \emph{ggplot} object. A plot of the chromatogram heatmap, with
identified peaks circled in red.
}
\description{
\code{plot_peak} plots peaks on a chromatograph plot.
}
\details{
This function circles the identified peaks in a sample over a
chromatograph plot (ideally smoothed) using \code{\link[ggplot2]{ggplot}}
from ggplot2 package \insertCite{ggplot2}{gcxgclab}.
}
\examples{
file1 <- system.file("extdata","sample1.cdf",package="gcxgclab")
frame <- extract_data(file1,mod_t=.5)
peaks <- top_peaks(frame$TIC_df, 5)
plot_peak(peaks, frame, title="Top 20 Peaks")

}
\references{
\insertAllCited{}
}
