% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coerce.R
\name{st_as_stars.cube}
\alias{st_as_stars.cube}
\title{Coerce gdalcubes object into a stars object}
\usage{
st_as_stars.cube(.x, ...)
}
\arguments{
\item{.x}{data cube object to coerce}

\item{...}{not used}
}
\value{
stars object
}
\description{
The function materializes a data cube as a temporary netCDF file and loads the file 
with the stars package.
}
\examples{
\donttest{
# create image collection from example Landsat data only 
# if not already done in other examples
if (!file.exists(file.path(tempdir(), "L8.db"))) {
  L8_files <- list.files(system.file("L8NY18", package = "gdalcubes"),
                         ".TIF", recursive = TRUE, full.names = TRUE)
  create_image_collection(L8_files, "L8_L1TP", file.path(tempdir(), "L8.db")) 
}

L8.col = image_collection(file.path(tempdir(), "L8.db"))
v = cube_view(extent=list(left=388941.2, right=766552.4, 
              bottom=4345299, top=4744931, t0="2018-04", t1="2018-04"),
              srs="EPSG:32618", nx = 497, ny=526, dt="P1M")
if(require("stars"))
  st_as_stars(select_bands(raster_cube(L8.col, v), c("B04", "B05")))
}
}
