% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{vsi_unlink_batch}
\alias{vsi_unlink_batch}
\title{Delete several files in a batch}
\usage{
vsi_unlink_batch(filenames)
}
\arguments{
\item{filenames}{Character vector. The list of files to delete.}
}
\value{
Invisibly, a logical vector of \code{length(filenames)} with values
depending on the success of deletion of the corresponding file.
\code{NULL} might be returned in case of a more general error (for example,
files belonging to different file system handlers).
}
\description{
\code{vsi_unlink_batch()} deletes a list of files passed in a character vector.
All files should belong to the same file system handler.
This is implemented efficiently for /vsis3/ and /vsigs/ (provided for
/vsigs/ that OAuth2 authentication is used).
This function is a wrapper for \code{VSIUnlinkBatch()} in the GDAL Common
Portability Library. Requires GDAL >= 3.1
}
\examples{
# for illustration only
# this would normally be used with GDAL virtual file systems
elev_file <- system.file("extdata/storml_elev.tif", package="gdalraster")
tcc_file <- system.file("extdata/storml_tcc.tif", package="gdalraster")

# Requires GDAL >= 3.1
if (as.integer(gdal_version()[2]) >= 3010000) {
  tmp_elev <- paste0(tempdir(), "/", "tmp_elev.tif")
  file.copy(elev_file,  tmp_elev)
  tmp_tcc <- paste0(tempdir(), "/", "tmp_tcc.tif")
  file.copy(tcc_file,  tmp_tcc)
  result <- vsi_unlink_batch(c(tmp_elev, tmp_tcc))
  print(result)
}
}
\seealso{
\code{\link[=deleteDataset]{deleteDataset()}}, \code{\link[=vsi_rmdir]{vsi_rmdir()}}, \code{\link[=vsi_unlink]{vsi_unlink()}}
}
