% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discretization.R
\name{st_unidisc}
\alias{st_unidisc}
\title{univariate discretization}
\usage{
st_unidisc(x, k, method = "quantile", factor = FALSE, seed = 123456789, ...)
}
\arguments{
\item{x}{A continuous numerical variable.}

\item{k}{(optional) Number of classes required, \code{k} must greater than \code{1}.}

\item{method}{Chosen classify style: one of "fixed", "sd", "equal", "pretty", "quantile", "kmeans",
"hclust", "bclust", "fisher", "jenks", "dpih", "headtails", "maximum", or "box". Default is \code{quantile}.}

\item{factor}{(optional) Default is \code{FALSE}, if \code{TRUE} returns cols as a factor with intervals as
labels rather than integers.}

\item{seed}{(optional) Random seed number, default is \code{123456789}. Setting random seed is useful when
the sample size is greater than \code{3000}(the default value for \code{largeN}) and the data is discretized
by sampling \verb{10\%}(the default value for \code{samp_prop}).}

\item{...}{(optional) Other arguments passed to \code{classInt::classify_intervals()},
see \code{?classInt::classify_intervals()}.}
}
\value{
A discrete vector after being discretized.
}
\description{
Function to classify univariate vector to interval, a wrapper of \code{classInt::classify_intervals()}.
}
\examples{
xvar = c(22361, 9573, 4836, 5309, 10384, 4359, 11016, 4414, 3327, 3408,
         17816, 6909, 6936, 7990, 3758, 3569, 21965, 3605, 2181, 1892,
         2459, 2934, 6399, 8578, 8537, 4840, 12132, 3734, 4372, 9073,
         7508, 5203)
st_unidisc(xvar, k = 5, method = 'sd')

}
\author{
Wenbo Lv \email{lyu.geosocial@gmail.com}
}
