% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psd_spade.R
\name{cpsd_spade}
\alias{cpsd_spade}
\title{compensated power of spatial determinant(CPSD)}
\usage{
cpsd_spade(yobs, xobs, xdisc, wt)
}
\arguments{
\item{yobs}{Variable Y}

\item{xobs}{The original undiscretized covariable X.}

\item{xdisc}{The discretized covariable X.}

\item{wt}{The spatial weight matrix.}
}
\value{
A value of compensated power of spatial determinant \code{Q_s}.
}
\description{
Function for calculate compensated power of spatial determinant \code{Q_s}.
}
\details{
The power of compensated spatial determinant formula is

\eqn{Q_s = \frac{q_s}{q_{s_{inforkep}}}
= \frac{1 - \frac{\sum_{h=1}^L N_h \Gamma_{kdep}}{N \Gamma_{totaldep}}}{1 - \frac{\sum_{h=1}^L N_h \Gamma_{hind}}{N \Gamma_{totalind}}}}
}
\examples{
data('sim')
wt = inverse_distance_weight(sim$lo,sim$la)
xa = sim$xa
xa_disc = st_unidisc(xa,5)
cpsd_spade(sim$y,xa,xa_disc,wt)

}
\references{
Xuezhi Cang & Wei Luo (2018) Spatial association detector (SPADE),International
Journal of Geographical Information Science, 32:10, 2055-2075, DOI:  10.1080/13658816.2018.1476693
}
\author{
Wenbo Lv \email{lyu.geosocial@gmail.com}
}
