% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update.geolm.R
\name{update.geolmStd}
\alias{update.geolmMan}
\alias{update.geolmStd}
\title{Update linear model for geostatistical data.}
\usage{
\method{update}{geolmStd}(object, cmod, ...)

\method{update}{geolmMan}(object, cmod, ...)
}
\arguments{
\item{object}{An object produced by the \code{geolm} function.}

\item{cmod}{A covariance model object obtained from one of the \code{cmod.*} functions or the \code{mle} function.}

\item{...}{Not implemented.}
}
\value{
Returns an object of the same class as \code{object}.
}
\description{
\code{update} updates a geostatistical linear model based on the given covariance model.
}
\examples{
# generate response
y = rnorm(10)
# generate coordinates
x1 = runif(10); x2 = runif(10)

# data frame for observed data
data = data.frame(y, x1, x2)
coords = cbind(x1, x2)
psill = 2 # partial sill
r = 4 # range parameter
evar = .1 # error variance
fvar = .1 # add finescale variance
# one can't generally distinguish between evar and fvar, but
# this is done for illustration purposes

cmod_std = cmod.std("exponential", psill = psill, r = r, 
                    evar = evar, fvar = fvar)

cmod_std2 = cmod.std("exponential", psill = psill + 1, r = r + .5, 
                     evar = evar + .01, fvar = fvar)

# check geolm update for universal kriging
gear1 = geolm(y ~ x1 + x2, data = data,
              coordnames = c("x1", "x2"),
              cmod = cmod_std)
gear2 = geolm(y ~ x1 + x2, data = data,
              coordnames = c("x1", "x2"),
              cmod = cmod_std2)
gear2b = update(gear1, cmod_std2)
identical(gear2, gear2b)
}
\author{
Joshua French
}

