% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spectrify.R
\name{spectrify}
\alias{spectrify}
\title{Make a raster layer SPECTRE compatible}
\usage{
spectrify(layers, continuous = TRUE, filepath = NULL)
}
\arguments{
\item{layers}{SpatRaster. A raster object that you would like to be SPECTRE compatible.}

\item{continuous}{logical. Whether the data present in \code{layers} is continuous. 
If \code{TRUE} bilinear interpolation will be used in the case of resampling and reprojection. 
if \code{FALSE} nearest neighbour will be used instead. 
See \code{\link[terra:resample]{terra::resample()}} for more information on interpolation methods.}

\item{filepath}{character. Optional file path to where the final raster layer 
should be saved, in the format "folder/file.tif". If \code{filepath} is \code{NULL} 
your layer will be saved to your current working directory.}
}
\value{
SpatRaster.
}
\description{
Transform a given raster object to the resolution, datum, 
projection and extent used in SPECTRE.
}
\examples{
\dontrun{
# For the sake of demonstration we will transform our raster layer "range".
distribution = gecko.data("range")
standard_dist = spectrify(distribution)
terra::plot(standard_dist)
}
}
