% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{Siga_cov}
\alias{Siga_cov}
\title{Generate Covariance Matrix}
\usage{
Siga_cov(rho, correlation, nt)
}
\arguments{
\item{rho}{Numeric, the correlation coefficient used for generating the covariance matrix.
For "cs" or "exchangeable", it represents the common correlation between any two observations.
For "AR1", it represents the correlation between two consecutive observations,
with the correlation decreasing for observations further apart.}

\item{correlation}{Character, specifies the correlation of correlation structure for the covariance matrix.
Options are "cs" or "exchangeable" for compound symmetry, "AR1" for autoregressive, and any other input
will result in an identity matrix.}

\item{nt}{Integer, the dimension of the square covariance matrix (number of time points or observations).}
}
\value{
A square matrix of dimension `nt` representing the specified covariance structure.
}
\description{
This function generates a covariance matrix based on the specified correlation structure.
The function supports "compound symmetry" (cs) and "autoregressive" (ar) correlation structures,
as well as an identity matrix as the default option when neither "cs" nor "AR1" is specified.
}
